/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.manager;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.frame.processor.FrameProcessor;

public class ProcessorAndCallback<T> {
    private final FrameProcessor<T> processor;
    private final Consumer<T> callback;

    public ProcessorAndCallback(FrameProcessor<T> processor, @Nullable Consumer<T> callback) {
        this.processor = (FrameProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
        this.callback = callback;
    }

    public FrameProcessor<T> processor() {
        return this.processor;
    }

    public void onComplete(T resultObject) {
        if (this.callback != null) {
            this.callback.accept(resultObject);
        }
    }
}

