/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;

public class MemoryBoundLinkedBlockingQueue<T> {
    private final long memoryBound;
    private final AtomicLong currentMemory;
    private final LinkedBlockingQueue<ObjectContainer<T>> queue;
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();

    public MemoryBoundLinkedBlockingQueue(long memoryBound) {
        this(new LinkedBlockingQueue<ObjectContainer<T>>(), memoryBound);
    }

    @VisibleForTesting
    MemoryBoundLinkedBlockingQueue(LinkedBlockingQueue<ObjectContainer<T>> queue, long memoryBound) {
        this.memoryBound = memoryBound;
        this.currentMemory = new AtomicLong(0L);
        this.queue = queue;
    }

    public boolean offer(ObjectContainer<T> item) {
        long itemLength = item.getSize();
        if (this.currentMemory.addAndGet(itemLength) <= this.memoryBound && this.queue.offer(item)) {
            return true;
        }
        this.currentMemory.addAndGet(-itemLength);
        return false;
    }

    public boolean offer(ObjectContainer<T> item, long timeout, TimeUnit unit) throws InterruptedException {
        long itemLength = item.getSize();
        long nanos = unit.toNanos(timeout);
        ReentrantLock putLock = this.putLock;
        putLock.lockInterruptibly();
        try {
            while (this.currentMemory.get() + itemLength > this.memoryBound) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            if (this.currentMemory.addAndGet(itemLength) <= this.memoryBound && this.queue.offer(item, timeout, unit)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (InterruptedException e) {
            this.currentMemory.addAndGet(-itemLength);
            throw e;
        }
        finally {
            putLock.unlock();
        }
        this.currentMemory.addAndGet(-itemLength);
        return false;
    }

    public ObjectContainer<T> take() throws InterruptedException {
        ObjectContainer<T> ret = this.queue.take();
        this.currentMemory.addAndGet(-ret.getSize());
        this.signalNotFull();
        return ret;
    }

    public Stream<ObjectContainer<T>> stream() {
        return this.queue.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drain(Collection<? super ObjectContainer<T>> buffer, int bytesToDrain, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(buffer);
        boolean signalNotFull = false;
        try {
            ObjectContainer<T> e;
            long deadline = System.nanoTime() + unit.toNanos(timeout);
            int added = 0;
            for (long bytesAdded = 0L; bytesAdded < (long)bytesToDrain && (e = this.queue.poll(deadline - System.nanoTime(), TimeUnit.NANOSECONDS)) != null; bytesAdded += e.getSize()) {
                this.currentMemory.addAndGet(-e.getSize());
                signalNotFull = true;
                buffer.add(e);
                ++added;
                e = this.queue.peek();
                if (e == null || bytesAdded + e.getSize() <= (long)bytesToDrain) continue;
                break;
            }
            int n = added;
            return n;
        }
        finally {
            if (signalNotFull) {
                this.signalNotFull();
            }
        }
    }

    public int size() {
        return this.queue.size();
    }

    public long byteSize() {
        return this.currentMemory.get();
    }

    public long remainingCapacity() {
        return this.memoryBound - this.currentMemory.get();
    }

    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            putLock.unlock();
        }
    }

    public static class ObjectContainer<T> {
        private final T data;
        private final long size;

        public ObjectContainer(T data, long size) {
            this.data = data;
            this.size = size;
        }

        public T getData() {
            return this.data;
        }

        public long getSize() {
            return this.size;
        }
    }
}

