/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Predicate;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.RetryUtils;

public class StreamUtils {
    public static long copyToFileAndClose(InputStream is, File file) throws IOException {
        FileUtils.mkdirp(file.getParentFile());
        try {
            long l;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                long result = ByteStreams.copy((InputStream)is, (OutputStream)os);
                ((OutputStream)os).flush();
                l = result;
            }
            return l;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyAndClose(InputStream is, OutputStream os) throws IOException {
        try {
            long retval = ByteStreams.copy((InputStream)is, (OutputStream)os);
            os.flush();
            long l = retval;
            return l;
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static long retryCopy(ByteSource byteSource, ByteSink byteSink, Predicate<Throwable> shouldRetry, int maxAttempts) {
        try {
            return RetryUtils.retry(() -> {
                try (InputStream inputStream = byteSource.openStream();){
                    Long l;
                    block12: {
                        OutputStream outputStream = byteSink.openStream();
                        try {
                            long retval = ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                            outputStream.flush();
                            l = retval;
                            if (outputStream == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        outputStream.close();
                    }
                    return l;
                }
            }, shouldRetry, maxAttempts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

