/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;

public class SwitchingEmitter
implements Emitter {
    private static final Logger log = new Logger(SwitchingEmitter.class);
    private final Emitter[] defaultEmitters;
    private final Map<String, List<Emitter>> feedToEmitters;
    private final Set<Emitter> knownEmitters;

    public SwitchingEmitter(Map<String, List<Emitter>> feedToEmitters, Emitter[] defaultEmitter) {
        this.feedToEmitters = feedToEmitters;
        this.defaultEmitters = defaultEmitter;
        ImmutableSet.Builder emittersSetBuilder = new ImmutableSet.Builder();
        emittersSetBuilder.addAll(Arrays.stream(defaultEmitter).iterator());
        for (List<Emitter> emitterList : feedToEmitters.values()) {
            for (Emitter emitter : emitterList) {
                emittersSetBuilder.add((Object)emitter);
            }
        }
        this.knownEmitters = emittersSetBuilder.build();
    }

    @Override
    @LifecycleStart
    public void start() {
        log.info("Starting Switching Emitter.", new Object[0]);
        for (Emitter e : this.knownEmitters) {
            log.info("Starting emitter %s.", e.getClass().getName());
            e.start();
        }
    }

    @Override
    public void emit(Event event) {
        for (Map.Entry<String, List<Emitter>> feedToEmitters : this.feedToEmitters.entrySet()) {
            if (!feedToEmitters.getKey().equals(event.getFeed())) continue;
            for (Emitter emitter : feedToEmitters.getValue()) {
                emitter.emit(event);
            }
            return;
        }
        for (Emitter emitter : this.defaultEmitters) {
            emitter.emit(event);
        }
    }

    @Override
    public void flush() throws IOException {
        boolean fail = false;
        log.info("Flushing Switching Emitter.", new Object[0]);
        for (Emitter e : this.knownEmitters) {
            try {
                log.info("Flushing emitter %s.", e.getClass().getName());
                e.flush();
            }
            catch (IOException ex) {
                log.error(ex, "Failed to flush emitter [%s]", e.getClass().getName());
                fail = true;
            }
        }
        if (fail) {
            throw new IOException("failed to flush one or more emitters");
        }
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        boolean fail = false;
        log.info("Closing Switching Emitter.", new Object[0]);
        for (Emitter e : this.knownEmitters) {
            try {
                log.info("Closing emitter %s.", e.getClass().getName());
                e.close();
            }
            catch (IOException ex) {
                log.error(ex, "Failed to close emitter [%s]", e.getClass().getName());
                fail = true;
            }
        }
        if (fail) {
            throw new IOException("failed to close one or more emitters");
        }
    }
}

