/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;

public class AlertBuilder
extends ServiceEventBuilder<AlertEvent> {
    public static final String EXCEPTION_TYPE_KEY = "exceptionType";
    public static final String EXCEPTION_MESSAGE_KEY = "exceptionMessage";
    public static final String EXCEPTION_STACK_TRACE_KEY = "exceptionStackTrace";
    protected final Map<String, Object> dataMap = Maps.newLinkedHashMap();
    protected final String description;
    protected final ServiceEmitter emitter;
    protected AlertEvent.Severity severity = AlertEvent.Severity.DEFAULT;

    public static AlertBuilder create(String descriptionFormat, Object ... objects) {
        return AlertBuilder.createEmittable(null, descriptionFormat, objects);
    }

    public static AlertBuilder createEmittable(ServiceEmitter emitter, String descriptionFormat, Object ... objects) {
        return new AlertBuilder(StringUtils.format(descriptionFormat, objects), emitter);
    }

    protected AlertBuilder(String description, ServiceEmitter emitter) {
        this.description = description;
        this.emitter = emitter;
    }

    public AlertBuilder addData(String identifier, Object value) {
        this.dataMap.put(identifier, value);
        return this;
    }

    public AlertBuilder addData(Map<String, Object> data) {
        this.dataMap.putAll(data);
        return this;
    }

    public AlertBuilder addThrowable(@Nullable Throwable t) {
        if (t != null) {
            StringWriter trace = new StringWriter();
            PrintWriter pw = new PrintWriter(trace);
            t.printStackTrace(pw);
            this.addData(EXCEPTION_TYPE_KEY, t.getClass().getName());
            this.addData(EXCEPTION_MESSAGE_KEY, t.getMessage());
            this.addData(EXCEPTION_STACK_TRACE_KEY, trace.toString());
        }
        return this;
    }

    public AlertBuilder severity(AlertEvent.Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public AlertEvent build(ImmutableMap<String, String> serviceDimensions) {
        return new AlertEvent(DateTimes.nowUtc(), serviceDimensions, this.severity, this.description, this.dataMap);
    }

    public void emit() {
        if (this.emitter == null) {
            throw new UnsupportedOperationException("Emitter is null, cannot emit.");
        }
        this.emitter.emit(this);
    }
}

