/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ComplexExpr;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;

class ArrayExpr
extends ConstantExpr<Object[]> {
    public ArrayExpr(ExpressionType outputType, @Nullable Object[] value) {
        super(outputType, value);
        Preconditions.checkArgument((boolean)outputType.isArray(), (String)"Output type %s is not an array", (Object)outputType);
    }

    @Override
    protected ExprEval realEval() {
        return ExprEval.ofArray(this.outputType, (Object[])this.value);
    }

    @Override
    public String stringify() {
        if (this.value == null) {
            return "null";
        }
        if (((Object[])this.value).length == 0) {
            return this.outputType.asTypeString() + "[]";
        }
        if (this.outputType.getElementType().is(ExprType.STRING)) {
            return StringUtils.format("%s[%s]", this.outputType.asTypeString(), ARG_JOINER.join(Arrays.stream((Object[])this.value).map(s -> s == null ? "null" : StringUtils.format("'%s'", StringEscapeUtils.escapeEcmaScript((String)((String)s)))).iterator()));
        }
        if (this.outputType.getElementType().isNumeric()) {
            return this.outputType.asTypeString() + Arrays.toString((Object[])this.value);
        }
        if (this.outputType.getElementType().is(ExprType.COMPLEX)) {
            Object[] stringified = new Object[((Object[])this.value).length];
            for (int i = 0; i < ((Object[])this.value).length; ++i) {
                stringified[i] = new ComplexExpr((ExpressionType)this.outputType.getElementType(), ((Object[])this.value)[i]).stringify();
            }
            return StringUtils.format("array(%s)", Arrays.toString(stringified));
        }
        if (this.outputType.getElementType().isArray()) {
            Object[] stringified = new Object[((Object[])this.value).length];
            for (int i = 0; i < ((Object[])this.value).length; ++i) {
                stringified[i] = new ArrayExpr((ExpressionType)this.outputType.getElementType(), (Object[])((Object[])this.value)[i]).stringify();
            }
            return StringUtils.format("array(%s)", Arrays.toString(stringified));
        }
        throw new IAE("cannot stringify array type %s", this.outputType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayExpr that = (ArrayExpr)o;
        return this.outputType.equals(that.outputType) && Arrays.equals((Object[])this.value, (Object[])that.value);
    }

    public int hashCode() {
        return Objects.hash(this.outputType, Arrays.hashCode((Object[])this.value));
    }

    @Override
    public String toString() {
        return Arrays.toString((Object[])this.value);
    }
}

