/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.NvlFunctionVectorProcessor;

public final class NvlDoubleVectorProcessor
extends NvlFunctionVectorProcessor<double[]> {
    private final double[] output;
    private final boolean[] outputNulls;

    public NvlDoubleVectorProcessor(ExprVectorProcessor<double[]> inputProcessor, ExprVectorProcessor<double[]> elseProcessor) {
        super(ExpressionType.DOUBLE, inputProcessor, elseProcessor);
        this.output = new double[inputProcessor.maxVectorSize()];
        this.outputNulls = new boolean[inputProcessor.maxVectorSize()];
    }

    @Override
    public ExprEvalVector<double[]> evalVector(Expr.VectorInputBinding bindings) {
        this.inputBindingFilterer.setBindings(bindings);
        ExprEvalVector<double[]> inputVector = this.inputProcessor.evalVector(bindings);
        if (inputVector.getNullVector() == null) {
            return inputVector;
        }
        double[] inputValues = inputVector.getDoubleVector();
        boolean[] inputNulls = inputVector.getNullVector();
        int[] selection = this.inputBindingFilterer.getVectorMatch().getSelection();
        int nulls = 0;
        for (int i = 0; i < bindings.getCurrentVectorSize(); ++i) {
            if (inputNulls[i]) {
                selection[nulls++] = i;
                continue;
            }
            this.outputNulls[i] = false;
            this.output[i] = inputValues[i];
        }
        if (nulls == 0) {
            return new ExprEvalDoubleVector(this.output, this.outputNulls);
        }
        this.inputBindingFilterer.getVectorMatch().setSelectionSize(nulls);
        if (nulls == bindings.getCurrentVectorSize()) {
            return this.elseProcessor.evalVector(bindings);
        }
        ExprEvalVector elseVector = this.elseProcessor.evalVector(this.inputBindingFilterer);
        double[] elseValues = elseVector.getDoubleVector();
        boolean[] elseNulls = elseVector.getNullVector();
        for (int i = 0; i < nulls; ++i) {
            int outIndex = selection[i];
            if (elseNulls != null && elseNulls[i]) {
                this.outputNulls[outIndex] = true;
                continue;
            }
            this.output[outIndex] = elseValues[i];
            this.outputNulls[outIndex] = false;
        }
        return new ExprEvalDoubleVector(this.output, this.outputNulls);
    }
}

