/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongBivariateDoubleLongFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.LongBivariateDoublesFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.LongBivariateLongDoubleFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.LongBivariateLongsFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.VectorMathBivariateLongProcessorFactory;
import org.apache.druid.math.expr.vector.functional.LongBivariateDoubleLongFunction;
import org.apache.druid.math.expr.vector.functional.LongBivariateDoublesFunction;
import org.apache.druid.math.expr.vector.functional.LongBivariateLongDoubleFunction;
import org.apache.druid.math.expr.vector.functional.LongBivariateLongsFunction;

public class SimpleVectorMathBivariateLongProcessorFactory
extends VectorMathBivariateLongProcessorFactory {
    private final LongBivariateLongsFunction longsFunction;
    private final LongBivariateLongDoubleFunction longDoubleFunction;
    private final LongBivariateDoubleLongFunction doubleLongFunction;
    private final LongBivariateDoublesFunction doublesFunction;

    public SimpleVectorMathBivariateLongProcessorFactory(LongBivariateLongsFunction longsFunction, LongBivariateLongDoubleFunction longDoubleFunction, LongBivariateDoubleLongFunction doubleLongFunction, LongBivariateDoublesFunction doublesFunction) {
        this.longsFunction = longsFunction;
        this.longDoubleFunction = longDoubleFunction;
        this.doubleLongFunction = doubleLongFunction;
        this.doublesFunction = doublesFunction;
    }

    @Override
    public final ExprVectorProcessor<long[]> longsProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        return new LongBivariateLongsFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), this.longsFunction);
    }

    @Override
    public final ExprVectorProcessor<long[]> longDoubleProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        return new LongBivariateLongDoubleFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), this.longDoubleFunction);
    }

    @Override
    public final ExprVectorProcessor<long[]> doubleLongProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        return new LongBivariateDoubleLongFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), this.doubleLongFunction);
    }

    @Override
    public final ExprVectorProcessor<long[]> doublesProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        return new LongBivariateDoublesFunctionVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector), this.doublesFunction);
    }
}

