/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryLogic;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryToolChest;

public class DefaultQueryRunnerFactoryConglomerate
implements QueryRunnerFactoryConglomerate {
    private final Map<Class<? extends Query>, QueryRunnerFactory> factories;
    private final Map<Class<? extends Query>, QueryToolChest> toolchests;
    private final Map<Class<? extends Query>, QueryLogic> querylogics;

    public static DefaultQueryRunnerFactoryConglomerate buildFromQueryRunnerFactories(Map<Class<? extends Query>, QueryRunnerFactory> factories) {
        return new DefaultQueryRunnerFactoryConglomerate(factories, Maps.transformValues(factories, f -> f.getToolchest()), Collections.emptyMap());
    }

    @Inject
    public DefaultQueryRunnerFactoryConglomerate(Map<Class<? extends Query>, QueryRunnerFactory> factories, Map<Class<? extends Query>, QueryToolChest> toolchests, Map<Class<? extends Query>, QueryLogic> querylogics) {
        this.factories = new IdentityHashMap<Class<? extends Query>, QueryRunnerFactory>(factories);
        this.toolchests = new IdentityHashMap<Class<? extends Query>, QueryToolChest>(toolchests);
        this.querylogics = new IdentityHashMap<Class<? extends Query>, QueryLogic>(querylogics);
    }

    @Override
    public <T, QueryType extends Query<T>> QueryRunnerFactory<T, QueryType> findFactory(QueryType query) {
        return this.factories.get(query.getClass());
    }

    @Override
    public <T, QueryType extends Query<T>> QueryToolChest<T, QueryType> getToolChest(QueryType query) {
        return this.toolchests.get(query.getClass());
    }

    @Override
    public <T, QueryType extends Query<T>> QueryLogic getQueryLogic(QueryType query) {
        return this.querylogics.get(query.getClass());
    }
}

