/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.java.util.common.HumanReadableBytes;

public class DruidProcessingBufferConfig {
    public static final HumanReadableBytes DEFAULT_PROCESSING_BUFFER_SIZE_BYTES = HumanReadableBytes.valueOf(-1);
    public static final int MAX_DEFAULT_PROCESSING_BUFFER_SIZE_BYTES = 0x40000000;
    public static final int DEFAULT_INITIAL_BUFFERS_FOR_INTERMEDIATE_POOL = 0;
    @JsonProperty
    private final HumanReadableBytes sizeBytes;
    @JsonProperty
    private final int poolCacheMaxCount;
    @JsonProperty
    private final int poolCacheInitialCount;

    @JsonCreator
    public DruidProcessingBufferConfig(@JsonProperty(value="sizeBytes") @Nullable HumanReadableBytes sizeBytes, @JsonProperty(value="poolCacheMaxCount") @Nullable Integer poolCacheMaxCount, @JsonProperty(value="poolCacheInitialCount") @Nullable Integer poolCacheInitialCount) {
        this.sizeBytes = Configs.valueOrDefault(sizeBytes, DEFAULT_PROCESSING_BUFFER_SIZE_BYTES);
        this.poolCacheInitialCount = Configs.valueOrDefault(poolCacheInitialCount, 0);
        this.poolCacheMaxCount = Configs.valueOrDefault(poolCacheMaxCount, Integer.MAX_VALUE);
    }

    public DruidProcessingBufferConfig() {
        this(null, null, null);
    }

    public HumanReadableBytes getBufferSize() {
        return this.sizeBytes;
    }

    public int getPoolCacheMaxCount() {
        return this.poolCacheMaxCount;
    }

    public int getPoolCacheInitialCount() {
        return this.poolCacheInitialCount;
    }
}

