/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.TruncatedResponseContextException;

public class QueryInterruptedException
extends QueryException {
    @JsonCreator
    public QueryInterruptedException(@JsonProperty(value="error") @Nullable String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") @Nullable String errorClass, @JsonProperty(value="host") @Nullable String host) {
        super(errorCode, errorMessage, errorClass, host);
    }

    public QueryInterruptedException(Throwable cause) {
        this(cause, QueryInterruptedException.getHostFromThrowable(cause));
    }

    public QueryInterruptedException(Throwable cause, String host) {
        super(cause, QueryInterruptedException.getErrorCodeFromThrowable(cause), QueryInterruptedException.getErrorClassFromThrowable(cause), host);
    }

    private static String getErrorCodeFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)e).getErrorCode();
        }
        if (e instanceof InterruptedException) {
            return "Query interrupted";
        }
        if (e instanceof CancellationException) {
            return "Query cancelled";
        }
        if (e instanceof UnsupportedOperationException) {
            return "Unsupported operation";
        }
        if (e instanceof TruncatedResponseContextException) {
            return "Truncated response context";
        }
        return "Unknown exception";
    }

    @Nullable
    private static String getErrorClassFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)e).getErrorClass();
        }
        if (e != null) {
            return e.getClass().getName();
        }
        return null;
    }

    @Nullable
    private static String getHostFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)e).getHost();
        }
        return null;
    }

    public static QueryInterruptedException wrapIfNeeded(Throwable e) {
        return e instanceof QueryInterruptedException ? (QueryInterruptedException)e : new QueryInterruptedException(e);
    }
}

