/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;

public class ExpressionLambdaAggregatorInputBindings
implements Expr.ObjectBinding {
    private final Expr.ObjectBinding inputBindings;
    private final String accumlatorIdentifier;
    private ExprEval<?> accumulator;

    public ExpressionLambdaAggregatorInputBindings(Expr.ObjectBinding inputBindings, String accumulatorIdentifier, ExprEval<?> initialValue) {
        this.accumlatorIdentifier = accumulatorIdentifier;
        this.inputBindings = inputBindings;
        this.accumulator = initialValue;
    }

    @Override
    @Nullable
    public Object get(String name) {
        if (this.accumlatorIdentifier.equals(name)) {
            return this.accumulator.valueOrDefault();
        }
        return this.inputBindings.get(name);
    }

    @Override
    @Nullable
    public ExpressionType getType(String name) {
        if (this.accumlatorIdentifier.equals(name)) {
            return this.accumulator.type();
        }
        return this.inputBindings.getType(name);
    }

    public void accumulate(ExprEval<?> eval) {
        this.accumulator = eval;
    }

    public ExprEval<?> getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(ExprEval<?> acc) {
        this.accumulator = acc;
    }
}

