/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.ColumnValueSelector;

public class SingleValueAggregator
implements Aggregator {
    final ColumnValueSelector selector;
    @Nullable
    private Object value;
    private boolean isAggregateInvoked = false;

    public SingleValueAggregator(ColumnValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void aggregate() {
        if (this.isAggregateInvoked) {
            throw InvalidInput.exception("Subquery expression returned more than one row", new Object[0]);
        }
        this.value = this.selector.getObject();
        this.isAggregateInvoked = true;
    }

    @Override
    public Object get() {
        return this.value;
    }

    @Override
    public float getFloat() {
        assert (this.validObjectValue());
        return this.value == null ? 0.0f : ((Number)this.value).floatValue();
    }

    @Override
    public long getLong() {
        assert (this.validObjectValue());
        return this.value == null ? 0L : ((Number)this.value).longValue();
    }

    @Override
    public double getDouble() {
        assert (this.validObjectValue());
        return this.value == null ? 0.0 : ((Number)this.value).doubleValue();
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    private boolean validObjectValue() {
        return !this.isNull();
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "SingleValueAggregator{selector=" + String.valueOf(this.selector) + ", value=" + String.valueOf(this.value) + ", isAggregateInvoked=" + this.isAggregateInvoked + "}";
    }
}

