/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;

public class RegexpLikeExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "regexp_like";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 2);
        final Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        if (!ExprUtils.isStringLiteral(patternExpr)) {
            throw this.validationFailed("pattern must be a STRING literal", new Object[0]);
        }
        final Pattern pattern = Pattern.compile(StringUtils.nullToEmptyNonDruidDataString((String)patternExpr.getLiteralValue()));
        class RegexpLikeExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private RegexpLikeExpr(List<Expr> args) {
                super(this$0, args);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String s = arg.eval(bindings).asString();
                if (s == null) {
                    return ExprEval.ofLong(null);
                }
                Matcher matcher = pattern.matcher(s);
                return ExprEval.ofLongBoolean(matcher.find());
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.LONG;
            }
        }
        return new RegexpLikeExpr(args);
    }
}

