/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;

@JsonTypeName(value="upper")
public class UpperExtractionFn
extends DimExtractionFn {
    private final Locale locale;
    @JsonProperty
    private final String localeString;

    public UpperExtractionFn(@JsonProperty(value="locale") String localeString) {
        this.localeString = localeString;
        this.locale = localeString == null ? Locale.getDefault() : Locale.forLanguageTag(localeString);
    }

    @Override
    @Nullable
    public String apply(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return key.toUpperCase(this.locale);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] localeBytes = StringUtils.toUtf8(StringUtils.nullToEmptyNonDruidDataString(this.localeString));
        return ByteBuffer.allocate(2 + localeBytes.length).put((byte)11).put((byte)-1).put(localeBytes).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpperExtractionFn that = (UpperExtractionFn)o;
        return Objects.equals(this.locale, that.locale) && Objects.equals(this.localeString, that.localeString);
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.localeString);
    }
}

