/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import java.util.Map;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;

public class LookupSegment
extends RowBasedSegment<Map.Entry<String, String>> {
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("k", ColumnType.STRING).add("v", ColumnType.STRING).build();

    public LookupSegment(String lookupName, LookupExtractorFactory lookupExtractorFactory) {
        super(SegmentId.dummy(lookupName), Sequences.simple(() -> {
            LookupExtractor extractor = (LookupExtractor)lookupExtractorFactory.get();
            if (!extractor.supportsAsMap()) {
                throw new ISE("Cannot retrieve map view from lookup[%s]", lookupExtractorFactory);
            }
            return extractor.asMap().entrySet().iterator();
        }), new RowAdapter<Map.Entry<String, String>>(){

            @Override
            public ToLongFunction<Map.Entry<String, String>> timestampFunction() {
                return row -> 0L;
            }

            @Override
            public Function<Map.Entry<String, String>, Object> columnFunction(String columnName) {
                if ("k".equals(columnName)) {
                    return Map.Entry::getKey;
                }
                if ("v".equals(columnName)) {
                    return Map.Entry::getValue;
                }
                return row -> null;
            }
        }, ROW_SIGNATURE);
    }
}

