/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;

public class AppendableMapOfColumns
implements AppendableRowsAndColumns {
    private final RowsAndColumns base;
    private final LinkedHashMap<String, Column> appendedColumns;
    private Set<String> colNames = null;

    public AppendableMapOfColumns(RowsAndColumns base) {
        this.base = base;
        this.appendedColumns = new LinkedHashMap();
    }

    @Override
    public void addColumn(String name, Column column) {
        Column prevValue = this.appendedColumns.put(name, column);
        if (prevValue != null) {
            throw new ISE("Tried to override column[%s]!?  Was[%s], now[%s]", name, prevValue, column);
        }
        if (this.colNames != null) {
            this.colNames.add(name);
        }
    }

    @Override
    public Collection<String> getColumnNames() {
        if (this.colNames == null) {
            this.colNames = new LinkedHashSet<String>(this.base.getColumnNames());
            this.colNames.addAll(this.appendedColumns.keySet());
        }
        return this.colNames;
    }

    @Override
    public int numRows() {
        return this.base.numRows();
    }

    @Override
    public Column findColumn(String name) {
        Column retVal = this.base.findColumn(name);
        if (retVal == null) {
            retVal = this.appendedColumns.get(name);
        }
        return retVal;
    }
}

