/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;

public class ConstantDimensionSelector
implements SingleValueHistoricalDimensionSelector,
IdLookup {
    private final String value;

    public ConstantDimensionSelector(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Use DimensionSelector.constant(null)");
        }
        this.value = value;
    }

    @Override
    public IndexedInts getRow() {
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getRowValue(int offset) {
        return 0;
    }

    @Override
    public IndexedInts getRow(int offset) {
        return this.getRow();
    }

    @Override
    public ValueMatcher makeValueMatcher(String matchValue) {
        return Objects.equals(this.value, matchValue) ? ValueMatchers.allTrue() : ValueMatchers.allFalse();
    }

    @Override
    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
        DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
        DruidPredicateMatch match = predicate.apply(this.value);
        if (match == DruidPredicateMatch.TRUE) {
            return ValueMatchers.allTrue();
        }
        if (match == DruidPredicateMatch.UNKNOWN) {
            return ValueMatchers.allUnknown();
        }
        return ValueMatchers.allFalse();
    }

    @Override
    public int getValueCardinality() {
        return 1;
    }

    @Override
    public String lookupName(int id) {
        assert (id == 0) : "id = " + id;
        return this.value;
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this;
    }

    @Override
    public int lookupId(String name) {
        return this.value.equals(name) ? 0 : -1;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.value;
    }

    @Override
    public Class classOfObject() {
        return String.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("value", this.value);
    }
}

