/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedCursorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class RowBasedSegment<RowType>
implements Segment {
    private final SegmentId segmentId;
    private final Sequence<RowType> rowSequence;
    private final RowAdapter<RowType> rowAdapter;
    private final RowSignature rowSignature;

    public RowBasedSegment(SegmentId segmentId, Sequence<RowType> rowSequence, RowAdapter<RowType> rowAdapter, RowSignature rowSignature) {
        this.segmentId = (SegmentId)Preconditions.checkNotNull((Object)segmentId, (Object)"segmentId");
        this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature");
        this.rowSequence = (Sequence)Preconditions.checkNotNull(rowSequence, (Object)"rowSequence");
        this.rowAdapter = (RowAdapter)Preconditions.checkNotNull(rowAdapter, (Object)"rowAdapter");
    }

    @Override
    @Nonnull
    public SegmentId getId() {
        return this.segmentId;
    }

    @Override
    @Nonnull
    public Interval getDataInterval() {
        return Intervals.ETERNITY;
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    public CursorFactory asCursorFactory() {
        return new RowBasedCursorFactory<RowType>(this.rowSequence, this.rowAdapter, this.rowSignature);
    }

    @Override
    public void close() {
    }
}

