/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import it.unimi.dsi.fastutil.Hash;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.error.DruidException;

public interface TypeStrategy<T>
extends Comparator<Object>,
Hash.Strategy<T> {
    public int estimateSizeBytes(T var1);

    public T read(ByteBuffer var1);

    public boolean readRetainsBufferReference();

    public int write(ByteBuffer var1, T var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public T read(ByteBuffer buffer, int offset) {
        int oldPosition = buffer.position();
        try {
            buffer.position(offset);
            T t = this.read(buffer);
            return t;
        }
        finally {
            buffer.position(oldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public int write(ByteBuffer buffer, int offset, T value, int maxSizeBytes) {
        int oldPosition = buffer.position();
        try {
            buffer.position(offset);
            int n = this.write(buffer, value, maxSizeBytes);
            return n;
        }
        finally {
            buffer.position(oldPosition);
        }
    }

    default public T fromBytes(byte[] value) {
        throw new IllegalStateException("Not supported");
    }

    default public boolean groupable() {
        return false;
    }

    default public int hashCode(T o) {
        throw DruidException.defensive("Not implemented. Check groupable() first", new Object[0]);
    }

    default public boolean equals(T a, T b) {
        throw DruidException.defensive("Not implemented. Check groupable() first", new Object[0]);
    }

    default public Class<?> getClazz() {
        throw DruidException.defensive("Not implemented. Check groupable() first", new Object[0]);
    }
}

