/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Rows;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.ValueMatchers;

public class PredicateValueMatcherFactory
implements ColumnProcessorFactory<ValueMatcher> {
    private final DruidPredicateFactory predicateFactory;

    public PredicateValueMatcherFactory(DruidPredicateFactory predicateFactory) {
        this.predicateFactory = predicateFactory;
    }

    @Override
    public ColumnType defaultType() {
        return ColumnType.UNKNOWN_COMPLEX;
    }

    @Override
    public ValueMatcher makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
        return ValueMatchers.makeStringValueMatcher(selector, this.predicateFactory, multiValue);
    }

    @Override
    public ValueMatcher makeFloatProcessor(BaseFloatColumnValueSelector selector) {
        return ValueMatchers.makeFloatValueMatcher(selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
        return ValueMatchers.makeDoubleValueMatcher(selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeLongProcessor(BaseLongColumnValueSelector selector) {
        return ValueMatchers.makeLongValueMatcher(selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeArrayProcessor(final BaseObjectColumnValueSelector<?> selector, @Nullable ColumnCapabilities columnCapabilities) {
        if (selector instanceof NilColumnValueSelector) {
            DruidPredicateMatch match = this.predicateFactory.makeArrayPredicate(columnCapabilities).apply(null);
            if (match == DruidPredicateMatch.TRUE) {
                return ValueMatchers.allTrue();
            }
            if (match == DruidPredicateMatch.UNKNOWN) {
                return ValueMatchers.makeAlwaysFalseWithNullUnknownObjectMatcher(selector);
            }
            return ValueMatchers.allFalse();
        }
        final DruidObjectPredicate<Object[]> predicate = this.predicateFactory.makeArrayPredicate(columnCapabilities);
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                Object o = selector.getObject();
                if (o == null || o instanceof Object[]) {
                    return predicate.apply((Object[])o).matches(includeUnknown);
                }
                if (o instanceof List) {
                    ExprEval oEval = ExprEval.bestEffortArray((List)o);
                    return predicate.apply(oEval.asArray()).matches(includeUnknown);
                }
                return predicate.apply(new Object[]{o}).matches(includeUnknown);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueMatcher makeComplexProcessor(final BaseObjectColumnValueSelector<?> selector) {
        if (selector instanceof NilColumnValueSelector) {
            DruidPredicateMatch match = this.predicateFactory.makeStringPredicate().apply(null);
            if (match == DruidPredicateMatch.TRUE) {
                return ValueMatchers.allTrue();
            }
            if (match == DruidPredicateMatch.UNKNOWN) {
                return ValueMatchers.makeAlwaysFalseWithNullUnknownObjectMatcher(selector);
            }
            return ValueMatchers.allFalse();
        }
        if (!PredicateValueMatcherFactory.isNumberOrString(selector.classOfObject())) {
            final DruidObjectPredicate<Object> predicate = this.predicateFactory.makeObjectPredicate();
            return new ValueMatcher(){

                @Override
                public boolean matches(boolean includeUnknown) {
                    Object val = selector.getObject();
                    return predicate.apply(val).matches(includeUnknown);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", selector);
                    inspector.visit("predicate", predicate);
                }
            };
        }
        return new ValueMatcher(){
            private DruidObjectPredicate<String> stringPredicate;
            private DruidLongPredicate longPredicate;
            private DruidFloatPredicate floatPredicate;
            private DruidDoublePredicate doublePredicate;
            private DruidObjectPredicate<Object[]> arrayPredicate;

            @Override
            public boolean matches(boolean includeUnknown) {
                Object rowValue = selector.getObject();
                if (rowValue == null) {
                    return this.getStringPredicate().apply(null).matches(includeUnknown);
                }
                if (rowValue instanceof Integer) {
                    return this.getLongPredicate().applyLong(((Integer)rowValue).intValue()).matches(includeUnknown);
                }
                if (rowValue instanceof Long) {
                    return this.getLongPredicate().applyLong((Long)rowValue).matches(includeUnknown);
                }
                if (rowValue instanceof Float) {
                    return this.getFloatPredicate().applyFloat(((Float)rowValue).floatValue()).matches(includeUnknown);
                }
                if (rowValue instanceof Number) {
                    return this.getDoublePredicate().applyDouble(((Number)rowValue).doubleValue()).matches(includeUnknown);
                }
                if (rowValue instanceof Object[]) {
                    return this.getArrayPredicate().apply((Object[])rowValue).matches(includeUnknown);
                }
                List<String> rowValueStrings = Rows.objectToStrings(rowValue);
                if (rowValueStrings.isEmpty()) {
                    return this.getStringPredicate().apply(null).matches(includeUnknown);
                }
                for (String rowValueString : rowValueStrings) {
                    if (!this.getStringPredicate().apply(rowValueString).matches(includeUnknown)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("factory", PredicateValueMatcherFactory.this.predicateFactory);
            }

            private DruidObjectPredicate<String> getStringPredicate() {
                if (this.stringPredicate == null) {
                    this.stringPredicate = PredicateValueMatcherFactory.this.predicateFactory.makeStringPredicate();
                }
                return this.stringPredicate;
            }

            private DruidLongPredicate getLongPredicate() {
                if (this.longPredicate == null) {
                    this.longPredicate = PredicateValueMatcherFactory.this.predicateFactory.makeLongPredicate();
                }
                return this.longPredicate;
            }

            private DruidFloatPredicate getFloatPredicate() {
                if (this.floatPredicate == null) {
                    this.floatPredicate = PredicateValueMatcherFactory.this.predicateFactory.makeFloatPredicate();
                }
                return this.floatPredicate;
            }

            private DruidDoublePredicate getDoublePredicate() {
                if (this.doublePredicate == null) {
                    this.doublePredicate = PredicateValueMatcherFactory.this.predicateFactory.makeDoublePredicate();
                }
                return this.doublePredicate;
            }

            private DruidObjectPredicate<Object[]> getArrayPredicate() {
                if (this.arrayPredicate == null) {
                    this.arrayPredicate = PredicateValueMatcherFactory.this.predicateFactory.makeArrayPredicate(null);
                }
                return this.arrayPredicate;
            }
        };
    }

    private static <T> boolean isNumberOrString(Class<T> clazz) {
        if (Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class);
    }
}

