/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ComparatorDimensionDictionary;
import org.apache.druid.segment.ComparatorSortedDimensionDictionary;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredDataProcessor;

public class ValueDictionary {
    private final ComparatorDimensionDictionary<String> stringDictionary = new ComparatorDimensionDictionary<String>(GenericIndexed.STRING_STRATEGY){

        @Override
        public long estimateSizeOfValue(String value) {
            return StructuredDataProcessor.estimateStringSize(value);
        }
    };
    private final ComparatorDimensionDictionary<Long> longDictionary = new ComparatorDimensionDictionary<Long>(ColumnType.LONG.getNullableStrategy()){

        @Override
        public long estimateSizeOfValue(Long value) {
            return StructuredDataProcessor.getLongObjectEstimateSize();
        }
    };
    private final ComparatorDimensionDictionary<Double> doubleDictionary = new ComparatorDimensionDictionary<Double>(ColumnType.DOUBLE.getNullableStrategy()){

        @Override
        public long estimateSizeOfValue(Double value) {
            return StructuredDataProcessor.getDoubleObjectEstimateSize();
        }
    };
    private final Set<Object[]> stringArrays = new TreeSet(ColumnType.STRING_ARRAY.getNullableStrategy());
    private final Set<Object[]> longArrays = new TreeSet(ColumnType.LONG_ARRAY.getNullableStrategy());
    private final Set<Object[]> doubleArrays = new TreeSet(ColumnType.DOUBLE_ARRAY.getNullableStrategy());
    private int arrayBytesSizeEstimate;

    public int addLongValue(@Nullable Long value) {
        this.longDictionary.add(value);
        return StructuredDataProcessor.getLongObjectEstimateSize();
    }

    public int addDoubleValue(@Nullable Double value) {
        this.doubleDictionary.add(value);
        return StructuredDataProcessor.getDoubleObjectEstimateSize();
    }

    public int addStringValue(@Nullable String value) {
        this.stringDictionary.add(value);
        return StructuredDataProcessor.estimateStringSize(value);
    }

    public int addStringArray(@Nullable Object[] value) {
        if (value == null) {
            return 0;
        }
        this.stringArrays.add(value);
        int sizeEstimate = 0;
        for (Object o : value) {
            if (o == null) continue;
            sizeEstimate += this.addStringValue((String)o);
        }
        this.arrayBytesSizeEstimate += sizeEstimate;
        return sizeEstimate;
    }

    public int addLongArray(@Nullable Object[] value) {
        if (value == null) {
            return 0;
        }
        this.longArrays.add(value);
        int sizeEstimate = 0;
        for (Object o : value) {
            if (o == null) continue;
            sizeEstimate += this.addLongValue((Long)o);
        }
        this.arrayBytesSizeEstimate += sizeEstimate;
        return sizeEstimate;
    }

    public int addDoubleArray(@Nullable Object[] value) {
        if (value == null) {
            return 0;
        }
        this.doubleArrays.add(value);
        int sizeEstimate = 0;
        for (Object o : value) {
            if (o == null) continue;
            sizeEstimate += this.addDoubleValue((Double)o);
        }
        this.arrayBytesSizeEstimate += sizeEstimate;
        return sizeEstimate;
    }

    public SortedValueDictionary getSortedCollector() {
        final ComparatorSortedDimensionDictionary<String> sortedStringDimensionDictionary = this.stringDictionary.sort();
        final Indexed<String> strings = new Indexed<String>(){

            @Override
            public int size() {
                return ValueDictionary.this.stringDictionary.size();
            }

            @Override
            public String get(int index) {
                return (String)sortedStringDimensionDictionary.getValueFromSortedId(index);
            }

            @Override
            public int indexOf(String value) {
                int id = ValueDictionary.this.stringDictionary.getId(value);
                return id < 0 ? -1 : sortedStringDimensionDictionary.getSortedIdFromUnsortedId(id);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
        final ComparatorSortedDimensionDictionary<Long> sortedLongDimensionDictionary = this.longDictionary.sort();
        final Indexed<Long> longs = new Indexed<Long>(){

            @Override
            public int size() {
                return ValueDictionary.this.longDictionary.size();
            }

            @Override
            public Long get(int index) {
                return (Long)sortedLongDimensionDictionary.getValueFromSortedId(index);
            }

            @Override
            public int indexOf(Long value) {
                int id = ValueDictionary.this.longDictionary.getId(value);
                return id < 0 ? -1 : sortedLongDimensionDictionary.getSortedIdFromUnsortedId(id);
            }

            @Override
            public Iterator<Long> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
        final ComparatorSortedDimensionDictionary<Double> sortedDoubleDimensionDictionary = this.doubleDictionary.sort();
        final Indexed<Double> doubles = new Indexed<Double>(){

            @Override
            public int size() {
                return ValueDictionary.this.doubleDictionary.size();
            }

            @Override
            public Double get(int index) {
                return (Double)sortedDoubleDimensionDictionary.getValueFromSortedId(index);
            }

            @Override
            public int indexOf(Double value) {
                int id = ValueDictionary.this.doubleDictionary.getId(value);
                return id < 0 ? -1 : sortedDoubleDimensionDictionary.getSortedIdFromUnsortedId(id);
            }

            @Override
            public Iterator<Double> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
        final int adjustLongs = 1 + strings.size();
        final int adjustDoubles = adjustLongs + longs.size();
        final TreeSet<Object[]> sortedArrays = new TreeSet<Object[]>(new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR.compare(this.convertArray(o1), this.convertArray(o2));
            }

            @Nullable
            private int[] convertArray(Object[] array) {
                if (array == null) {
                    return null;
                }
                int[] globalIds = new int[array.length];
                for (int i = 0; i < array.length; ++i) {
                    globalIds[i] = array[i] == null ? 0 : (array[i] instanceof String ? 1 + strings.indexOf((String)array[i]) : (array[i] instanceof Long ? longs.indexOf((Long)array[i]) + adjustLongs : (array[i] instanceof Double ? doubles.indexOf((Double)array[i]) + adjustDoubles : -1)));
                    Preconditions.checkArgument((globalIds[i] >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (int)globalIds[i], (Object)array[i]);
                }
                return globalIds;
            }
        });
        sortedArrays.addAll(this.stringArrays);
        sortedArrays.addAll(this.longArrays);
        sortedArrays.addAll(this.doubleArrays);
        Indexed<Object[]> sortedArraysIndexed = new Indexed<Object[]>(){

            @Override
            public Iterator<Object[]> iterator() {
                return sortedArrays.iterator();
            }

            @Override
            public int size() {
                return sortedArrays.size();
            }

            @Override
            @Nullable
            public Object[] get(int index) {
                return new Object[0];
            }

            @Override
            public int indexOf(@Nullable Object[] value) {
                throw new UnsupportedOperationException("indexOf not supported");
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
        return new SortedValueDictionary(strings, longs, doubles, sortedArraysIndexed, null);
    }

    public long sizeInBytes() {
        return this.stringDictionary.sizeInBytes() + this.longDictionary.sizeInBytes() + this.doubleDictionary.sizeInBytes() + (long)this.arrayBytesSizeEstimate;
    }

    public int getCardinality() {
        return this.stringDictionary.size() + this.longDictionary.size() + this.doubleDictionary.size() + this.stringArrays.size() + this.longArrays.size() + this.doubleArrays.size();
    }
}

