/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.BaseDimensionRangeShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.StringPartitionChunk;

public class DimensionRangeShardSpec
extends BaseDimensionRangeShardSpec {
    public static final int UNKNOWN_NUM_CORE_PARTITIONS = -1;
    private final int partitionNum;
    private final int numCorePartitions;

    @JsonCreator
    public DimensionRangeShardSpec(@JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="start") @Nullable StringTuple start, @JsonProperty(value="end") @Nullable StringTuple end, @JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="numCorePartitions") @Nullable Integer numCorePartitions) {
        super(dimensions, start, end);
        Preconditions.checkArgument((partitionNum >= 0 ? 1 : 0) != 0, (Object)"partitionNum >= 0");
        Preconditions.checkArgument((dimensions != null && !dimensions.isEmpty() ? 1 : 0) != 0, (Object)"dimensions should be non-null and non-empty");
        this.partitionNum = partitionNum;
        this.numCorePartitions = numCorePartitions == null ? -1 : numCorePartitions;
    }

    @JsonProperty(value="dimensions")
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @Nullable
    @JsonProperty(value="start")
    public StringTuple getStartTuple() {
        return this.start;
    }

    @Nullable
    @JsonProperty(value="end")
    public StringTuple getEndTuple() {
        return this.end;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    @JsonProperty
    public int getNumCorePartitions() {
        return this.numCorePartitions;
    }

    public boolean isNumCorePartitionsUnknown() {
        return this.numCorePartitions == -1;
    }

    @Override
    public List<String> getDomainDimensions() {
        return Collections.unmodifiableList(this.dimensions);
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        StringTuple segmentStart = this.start == null ? new StringTuple(new String[this.dimensions.size()]) : this.start;
        StringTuple segmentEnd = this.end == null ? new StringTuple(new String[this.dimensions.size()]) : this.end;
        boolean effectiveDomainIsStart = true;
        boolean effectiveDomainIsEnd = true;
        for (int i = 0; i < this.dimensions.size(); ++i) {
            RangeSet effectiveDomainForDimension;
            Iterator effectiveDomainRangeIterator;
            String dimension = (String)this.dimensions.get(i);
            TreeRangeSet queryDomainForDimension = domain.get(dimension);
            if (queryDomainForDimension == null) {
                queryDomainForDimension = TreeRangeSet.create();
                queryDomainForDimension.add(Range.all());
            }
            Range rangeTillSegmentBoundary = Range.all();
            if (effectiveDomainIsStart && segmentStart.get(i) != null) {
                rangeTillSegmentBoundary = rangeTillSegmentBoundary.intersection(Range.atLeast((Comparable)((Object)segmentStart.get(i))));
            }
            if (effectiveDomainIsEnd && segmentEnd.get(i) != null) {
                rangeTillSegmentBoundary = rangeTillSegmentBoundary.intersection(Range.atMost((Comparable)((Object)segmentEnd.get(i))));
            }
            if (!(effectiveDomainRangeIterator = (effectiveDomainForDimension = queryDomainForDimension.subRangeSet(rangeTillSegmentBoundary)).asRanges().iterator()).hasNext()) {
                return false;
            }
            Range firstRange = (Range)effectiveDomainRangeIterator.next();
            boolean effectiveDomainIsSingleRange = !effectiveDomainRangeIterator.hasNext();
            effectiveDomainIsStart = effectiveDomainIsStart && effectiveDomainIsSingleRange && segmentStart.get(i) != null && firstRange.equals((Object)Range.singleton((Comparable)((Object)segmentStart.get(i))));
            boolean bl = effectiveDomainIsEnd = effectiveDomainIsEnd && effectiveDomainIsSingleRange && segmentEnd.get(i) != null && firstRange.equals((Object)Range.singleton((Comparable)((Object)segmentEnd.get(i))));
            if (effectiveDomainIsStart || effectiveDomainIsEnd) continue;
            return true;
        }
        return true;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        if (this.isNumCorePartitionsUnknown()) {
            return StringPartitionChunk.make(this.start, this.end, this.partitionNum, obj);
        }
        return new NumberedPartitionChunk<T>(this.partitionNum, this.numCorePartitions, obj);
    }

    @Override
    public String getType() {
        return "range";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionRangeShardSpec shardSpec = (DimensionRangeShardSpec)o;
        return this.partitionNum == shardSpec.partitionNum && this.numCorePartitions == shardSpec.numCorePartitions && Objects.equals(this.dimensions, shardSpec.dimensions) && Objects.equals(this.start, shardSpec.start) && Objects.equals(this.end, shardSpec.end);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.start, this.end, this.partitionNum, this.numCorePartitions);
    }

    public String toString() {
        return "DimensionRangeShardSpec{dimensions='" + String.valueOf(this.dimensions) + "', start='" + String.valueOf(this.start) + "', end='" + String.valueOf(this.end) + "', partitionNum=" + this.partitionNum + ", numCorePartitions=" + this.numCorePartitions + "}";
    }
}

