/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskLockHelper;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class SegmentTransactionalInsertAction
implements TaskAction<SegmentPublishResult> {
    @Nullable
    private final Set<DataSegment> segmentsToBeOverwritten;
    private final Set<DataSegment> segments;
    @Nullable
    private final DataSourceMetadata startMetadata;
    @Nullable
    private final DataSourceMetadata endMetadata;
    @Nullable
    private final String dataSource;
    @Nullable
    private final SegmentSchemaMapping segmentSchemaMapping;

    public static SegmentTransactionalInsertAction overwriteAction(@Nullable Set<DataSegment> segmentsToBeOverwritten, Set<DataSegment> segmentsToPublish, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        return new SegmentTransactionalInsertAction(segmentsToBeOverwritten, segmentsToPublish, null, null, null, segmentSchemaMapping);
    }

    public static SegmentTransactionalInsertAction appendAction(Set<DataSegment> segments, @Nullable DataSourceMetadata startMetadata, @Nullable DataSourceMetadata endMetadata, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        return new SegmentTransactionalInsertAction(null, segments, startMetadata, endMetadata, null, segmentSchemaMapping);
    }

    public static SegmentTransactionalInsertAction commitMetadataOnlyAction(String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) {
        return new SegmentTransactionalInsertAction(null, null, startMetadata, endMetadata, dataSource, null);
    }

    @JsonCreator
    private SegmentTransactionalInsertAction(@JsonProperty(value="segmentsToBeOverwritten") @Nullable Set<DataSegment> segmentsToBeOverwritten, @JsonProperty(value="segments") @Nullable Set<DataSegment> segments, @JsonProperty(value="startMetadata") @Nullable DataSourceMetadata startMetadata, @JsonProperty(value="endMetadata") @Nullable DataSourceMetadata endMetadata, @JsonProperty(value="dataSource") @Nullable String dataSource, @JsonProperty(value="segmentSchemaMapping") @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        this.segmentsToBeOverwritten = segmentsToBeOverwritten;
        this.segments = segments == null ? ImmutableSet.of() : ImmutableSet.copyOf(segments);
        this.startMetadata = startMetadata;
        this.endMetadata = endMetadata;
        this.dataSource = dataSource;
        this.segmentSchemaMapping = segmentSchemaMapping;
    }

    @JsonProperty
    @Nullable
    public Set<DataSegment> getSegmentsToBeOverwritten() {
        return this.segmentsToBeOverwritten;
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    @Nullable
    public DataSourceMetadata getStartMetadata() {
        return this.startMetadata;
    }

    @JsonProperty
    @Nullable
    public DataSourceMetadata getEndMetadata() {
        return this.endMetadata;
    }

    @JsonProperty
    @Nullable
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    @Nullable
    public SegmentSchemaMapping getSegmentSchemaMapping() {
        return this.segmentSchemaMapping;
    }

    @Override
    public TypeReference<SegmentPublishResult> getReturnTypeReference() {
        return new TypeReference<SegmentPublishResult>(){};
    }

    @Override
    public SegmentPublishResult perform(Task task, TaskActionToolbox toolbox) {
        SegmentPublishResult retVal;
        List<TaskLock> locks;
        if (this.segments.isEmpty()) {
            SegmentPublishResult retVal2;
            try {
                retVal2 = toolbox.getIndexerMetadataStorageCoordinator().commitMetadataOnly(this.dataSource, this.startMetadata, this.endMetadata);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return retVal2;
        }
        HashSet<DataSegment> allSegments = new HashSet<DataSegment>(this.segments);
        if (this.segmentsToBeOverwritten != null) {
            allSegments.addAll(this.segmentsToBeOverwritten);
        }
        TaskLocks.checkLockCoversSegments(task, toolbox.getTaskLockbox(), allSegments);
        if (this.segmentsToBeOverwritten != null && !this.segmentsToBeOverwritten.isEmpty() && (locks = toolbox.getTaskLockbox().findLocksForTask(task)).get(0).getGranularity() == LockGranularity.SEGMENT) {
            this.checkWithSegmentLock();
        }
        try {
            retVal = toolbox.getTaskLockbox().doInCriticalSection(task, allSegments.stream().map(DataSegment::getInterval).collect(Collectors.toSet()), CriticalAction.builder().onValidLocks(() -> toolbox.getIndexerMetadataStorageCoordinator().commitSegmentsAndMetadata(this.segments, this.startMetadata, this.endMetadata, this.segmentSchemaMapping)).onInvalidLocks(() -> SegmentPublishResult.fail((String)"Invalid task locks. Maybe they are revoked by a higher priority task. Please check the overlord log for details.", (Object[])new Object[0])).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IndexTaskUtils.emitSegmentPublishMetrics(retVal, task, toolbox);
        return retVal;
    }

    private void checkWithSegmentLock() {
        Map<Interval, List<DataSegment>> oldSegmentsMap = SegmentTransactionalInsertAction.groupSegmentsByIntervalAndSort(this.segmentsToBeOverwritten);
        Map<Interval, List<DataSegment>> newSegmentsMap = SegmentTransactionalInsertAction.groupSegmentsByIntervalAndSort(this.segments);
        oldSegmentsMap.values().forEach(TaskLockHelper::verifyRootPartitionIsAdjacentAndAtomicUpdateGroupIsFull);
        newSegmentsMap.values().forEach(TaskLockHelper::verifyRootPartitionIsAdjacentAndAtomicUpdateGroupIsFull);
        oldSegmentsMap.forEach((interval, oldSegmentsPerInterval) -> {
            List newSegmentsPerInterval = (List)Preconditions.checkNotNull((Object)((List)newSegmentsMap.get(interval)), (String)"segments of interval[%s]", (Object)interval);
            int oldStartRootPartitionId = ((DataSegment)oldSegmentsPerInterval.get(0)).getStartRootPartitionId();
            int oldEndRootPartitionId = ((DataSegment)oldSegmentsPerInterval.get(oldSegmentsPerInterval.size() - 1)).getEndRootPartitionId();
            int newStartRootPartitionId = ((DataSegment)newSegmentsPerInterval.get(0)).getStartRootPartitionId();
            int newEndRootPartitionId = ((DataSegment)newSegmentsPerInterval.get(newSegmentsPerInterval.size() - 1)).getEndRootPartitionId();
            if (oldStartRootPartitionId != newStartRootPartitionId || oldEndRootPartitionId != newEndRootPartitionId) {
                throw new ISE("Root partition range[%d, %d] of new segments doesn't match to root partition range[%d, %d] of old segments", new Object[]{newStartRootPartitionId, newEndRootPartitionId, oldStartRootPartitionId, oldEndRootPartitionId});
            }
            newSegmentsPerInterval.forEach(eachNewSegment -> oldSegmentsPerInterval.forEach(eachOldSegment -> {
                if (eachNewSegment.getMinorVersion() <= eachOldSegment.getMinorVersion()) {
                    throw new ISE("New segment[%s] have a smaller minor version than old segment[%s]", new Object[]{eachNewSegment, eachOldSegment});
                }
            }));
        });
    }

    private static Map<Interval, List<DataSegment>> groupSegmentsByIntervalAndSort(Set<DataSegment> segments) {
        HashMap<Interval, List<DataSegment>> segmentsMap = new HashMap<Interval, List<DataSegment>>();
        segments.forEach(segment -> segmentsMap.computeIfAbsent(segment.getInterval(), k -> new ArrayList()).add(segment));
        segmentsMap.values().forEach(segmentsPerInterval -> segmentsPerInterval.sort((s1, s2) -> {
            if (s1.getStartRootPartitionId() != s2.getStartRootPartitionId()) {
                return Integer.compare(s1.getStartRootPartitionId(), s2.getStartRootPartitionId());
            }
            return Integer.compare(s1.getEndRootPartitionId(), s2.getEndRootPartitionId());
        }));
        return segmentsMap;
    }

    @Override
    public String toString() {
        return "SegmentTransactionalInsertAction{segmentsToBeOverwritten=" + String.valueOf(SegmentUtils.commaSeparatedIdentifiers(this.segmentsToBeOverwritten)) + ", segments=" + String.valueOf(SegmentUtils.commaSeparatedIdentifiers(this.segments)) + ", startMetadata=" + String.valueOf(this.startMetadata) + ", endMetadata=" + String.valueOf(this.endMetadata) + ", dataSource='" + this.dataSource + "'}";
    }
}

