/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.segment.indexing.IOConfig;

@JsonTypeName(value="compact")
public class CompactionIOConfig
implements IOConfig {
    private final CompactionInputSpec inputSpec;
    private final boolean allowNonAlignedInterval;
    private final boolean dropExisting;

    @JsonCreator
    public CompactionIOConfig(@JsonProperty(value="inputSpec") CompactionInputSpec inputSpec, @JsonProperty(value="allowNonAlignedInterval") boolean allowNonAlignedInterval, @JsonProperty(value="dropExisting") @Nullable Boolean dropExisting) {
        this.inputSpec = inputSpec;
        this.allowNonAlignedInterval = allowNonAlignedInterval;
        this.dropExisting = dropExisting == null ? false : dropExisting;
    }

    @JsonProperty
    public CompactionInputSpec getInputSpec() {
        return this.inputSpec;
    }

    @JsonProperty(value="allowNonAlignedInterval")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isAllowNonAlignedInterval() {
        return this.allowNonAlignedInterval;
    }

    @JsonProperty
    public boolean isDropExisting() {
        return this.dropExisting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionIOConfig that = (CompactionIOConfig)o;
        return this.allowNonAlignedInterval == that.allowNonAlignedInterval && this.dropExisting == that.dropExisting && Objects.equals(this.inputSpec, that.inputSpec);
    }

    public int hashCode() {
        return Objects.hash(this.inputSpec, this.allowNonAlignedInterval, this.dropExisting);
    }

    public String toString() {
        return "CompactionIOConfig{inputSpec=" + String.valueOf(this.inputSpec) + ", allowNonAlignedInterval=" + this.allowNonAlignedInterval + ", dropExisting=" + this.dropExisting + "}";
    }
}

