/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.iterator;

import java.util.List;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.DefaultIndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;

public class RangePartitionIndexTaskInputRowIteratorBuilder
implements IndexTaskInputRowIteratorBuilder {
    private final DefaultIndexTaskInputRowIteratorBuilder delegate = new DefaultIndexTaskInputRowIteratorBuilder();

    public RangePartitionIndexTaskInputRowIteratorBuilder(List<String> partitionDimensions, boolean skipNull) {
        if (skipNull) {
            this.delegate.appendInputRowHandler(RangePartitionIndexTaskInputRowIteratorBuilder.createOnlySingleDimensionValueRowsHandler(partitionDimensions));
        } else {
            this.delegate.appendInputRowHandler(RangePartitionIndexTaskInputRowIteratorBuilder.createOnlySingleOrNullDimensionValueRowsHandler(partitionDimensions));
        }
    }

    @Override
    public IndexTaskInputRowIteratorBuilder delegate(CloseableIterator<InputRow> inputRowIterator) {
        return this.delegate.delegate((CloseableIterator)inputRowIterator);
    }

    @Override
    public IndexTaskInputRowIteratorBuilder granularitySpec(GranularitySpec granularitySpec) {
        return this.delegate.granularitySpec(granularitySpec);
    }

    @Override
    public HandlingInputRowIterator build() {
        return this.delegate.build();
    }

    private static HandlingInputRowIterator.InputRowHandler createOnlySingleDimensionValueRowsHandler(List<String> partitionDimensions) {
        return inputRow -> {
            RangePartitionIndexTaskInputRowIteratorBuilder.ensureNoMultiValuedDimensions(inputRow, partitionDimensions);
            return RangePartitionIndexTaskInputRowIteratorBuilder.hasEmptyDimensions(inputRow, partitionDimensions);
        };
    }

    private static HandlingInputRowIterator.InputRowHandler createOnlySingleOrNullDimensionValueRowsHandler(List<String> partitionDimensions) {
        return inputRow -> {
            RangePartitionIndexTaskInputRowIteratorBuilder.ensureNoMultiValuedDimensions(inputRow, partitionDimensions);
            return false;
        };
    }

    private static boolean hasEmptyDimensions(InputRow inputRow, List<String> partitionDimensions) {
        for (String dimension : partitionDimensions) {
            int dimensionValueCount = inputRow.getDimension(dimension).size();
            if (dimensionValueCount != 0) continue;
            return true;
        }
        return false;
    }

    private static void ensureNoMultiValuedDimensions(InputRow inputRow, List<String> partitionDimensions) throws IAE {
        for (String dimension : partitionDimensions) {
            int dimensionValueCount = inputRow.getDimension(dimension).size();
            if (dimensionValueCount <= 1) continue;
            throw new IAE("Cannot partition on multi-value dimension [%s] for input row [%s]", new Object[]{dimension, inputRow});
        }
    }
}

