/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.joda.time.Interval;

public class LockRequestForNewSegment
implements LockRequest {
    private final LockGranularity lockGranularity;
    private final TaskLockType lockType;
    private final String groupId;
    private final String dataSource;
    private final Interval interval;
    private final PartialShardSpec partialShardSpec;
    private final int priority;
    private final String sequenceName;
    @Nullable
    private final String previousSegmentId;
    private final boolean skipSegmentLineageCheck;
    private String version;

    public LockRequestForNewSegment(LockGranularity lockGranularity, TaskLockType lockType, String groupId, String dataSource, Interval interval, PartialShardSpec partialShardSpec, int priority, String sequenceName, @Nullable String previousSegmentId, boolean skipSegmentLineageCheck) {
        this.lockGranularity = lockGranularity;
        this.lockType = lockType;
        this.groupId = groupId;
        this.dataSource = dataSource;
        this.interval = interval;
        this.partialShardSpec = partialShardSpec;
        this.priority = priority;
        this.sequenceName = sequenceName;
        this.previousSegmentId = previousSegmentId;
        this.skipSegmentLineageCheck = skipSegmentLineageCheck;
    }

    @VisibleForTesting
    public LockRequestForNewSegment(LockGranularity lockGranularity, TaskLockType lockType, Task task, Interval interval, PartialShardSpec partialShardSpec, String sequenceName, @Nullable String previousSegmentId, boolean skipSegmentLineageCheck) {
        this(lockGranularity, lockType, task.getGroupId(), task.getDataSource(), interval, partialShardSpec, task.getPriority(), sequenceName, previousSegmentId, skipSegmentLineageCheck);
    }

    @Override
    public LockGranularity getGranularity() {
        return this.lockGranularity;
    }

    @Override
    public TaskLockType getType() {
        return this.lockType;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public PartialShardSpec getPartialShardSpec() {
        return this.partialShardSpec;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = TaskLocks.defaultLockVersion(this.lockType);
        }
        return this.version;
    }

    @Override
    public boolean isRevoked() {
        return false;
    }

    @Override
    public TaskLock toLock() {
        throw new UnsupportedOperationException("This lockRequest must be converted to SpecificSegmentLockRequest or TimeChunkLockRequest first to convert to TaskLock");
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    @Nullable
    public String getPreviousSegmentId() {
        return this.previousSegmentId;
    }

    public boolean isSkipSegmentLineageCheck() {
        return this.skipSegmentLineageCheck;
    }

    public String toString() {
        return "LockRequestForNewSegment{lockGranularity=" + String.valueOf((Object)this.lockGranularity) + ", lockType=" + String.valueOf((Object)this.lockType) + ", groupId='" + this.groupId + "', dataSource='" + this.dataSource + "', interval=" + String.valueOf(this.interval) + ", partialShardSpec=" + String.valueOf(this.partialShardSpec) + ", priority=" + this.priority + ", sequenceName='" + this.sequenceName + "', previousSegmentId='" + this.previousSegmentId + "', skipSegmentLineageCheck=" + this.skipSegmentLineageCheck + "}";
    }
}

