/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http;

import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.error.NotFound;
import org.apache.druid.indexing.compact.CompactionScheduler;
import org.apache.druid.indexing.compact.CompactionSupervisorSpec;
import org.apache.druid.indexing.overlord.http.CompactionConfigHistoryResponse;
import org.apache.druid.indexing.overlord.http.CompactionConfigsResponse;
import org.apache.druid.indexing.overlord.supervisor.CompactionSupervisorManager;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.apache.druid.server.http.ServletResourceUtils;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@Path(value="/druid/indexer/v1/compaction")
public class OverlordCompactionResource {
    private final CompactionScheduler scheduler;
    private final AuthorizerMapper authorizerMapper;
    private final CoordinatorClient coordinatorClient;
    private final CoordinatorConfigManager configManager;
    private final CompactionSupervisorManager supervisorManager;

    @Inject
    public OverlordCompactionResource(CompactionScheduler scheduler, AuthorizerMapper authorizerMapper, CoordinatorClient coordinatorClient, CoordinatorConfigManager configManager, CompactionSupervisorManager supervisorManager) {
        this.scheduler = scheduler;
        this.configManager = configManager;
        this.authorizerMapper = authorizerMapper;
        this.coordinatorClient = coordinatorClient;
        this.supervisorManager = supervisorManager;
    }

    @GET
    @Path(value="/isSupervisorEnabled")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response isCompactionSupervisorEnabled() {
        return ServletResourceUtils.buildReadResponse(this.scheduler::isEnabled);
    }

    @POST
    @Path(value="/config/cluster")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response updateClusterCompactionConfig(ClusterCompactionConfig updatePayload, @Context HttpServletRequest req) {
        AuditInfo auditInfo = AuthorizationUtils.buildAuditInfo((HttpServletRequest)req);
        return ServletResourceUtils.buildUpdateResponse(() -> this.configManager.updateClusterCompactionConfig(updatePayload, auditInfo));
    }

    @GET
    @Path(value="/config/cluster")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getClusterCompactionConfig() {
        return ServletResourceUtils.buildReadResponse(() -> ((CoordinatorConfigManager)this.configManager).getClusterCompactionConfig());
    }

    @GET
    @Path(value="/status/datasources")
    @Produces(value={"application/json"})
    public Response getAllCompactionSnapshots(@Context HttpServletRequest request) {
        if (this.scheduler.isEnabled()) {
            return ServletResourceUtils.buildReadResponse(() -> {
                List<AutoCompactionSnapshot> allSnapshots = List.copyOf(this.scheduler.getAllCompactionSnapshots().values());
                return new CompactionStatusResponse(AuthorizationUtils.filterByAuthorizedDatasources((HttpServletRequest)request, allSnapshots, AutoCompactionSnapshot::getDataSource, (AuthorizerMapper)this.authorizerMapper));
            });
        }
        return OverlordCompactionResource.buildResponse(this.coordinatorClient.getCompactionSnapshots(null));
    }

    @GET
    @Path(value="/status/datasources/{dataSource}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatasourceCompactionSnapshot(@PathParam(value="dataSource") String dataSource) {
        if (OverlordCompactionResource.isEmpty(dataSource)) {
            return OverlordCompactionResource.invalidInputResponse("No DataSource specified", new Object[0]);
        }
        if (this.scheduler.isEnabled()) {
            AutoCompactionSnapshot snapshot = this.scheduler.getCompactionSnapshot(dataSource);
            if (snapshot == null) {
                return ServletResourceUtils.buildErrorResponseFrom((DruidException)NotFound.exception((String)"Unknown DataSource", (Object[])new Object[0]));
            }
            return Response.ok((Object)snapshot).build();
        }
        return OverlordCompactionResource.buildResponse(Futures.transform((ListenableFuture)this.coordinatorClient.getCompactionSnapshots(dataSource), statusResponse -> (AutoCompactionSnapshot)Iterators.getOnlyElement(statusResponse.getLatestStatus().iterator()), (Executor)MoreExecutors.directExecutor()));
    }

    @GET
    @Path(value="/config/datasources")
    @Produces(value={"application/json"})
    public Response getAllCompactionConfigs(@Context HttpServletRequest request) {
        if (this.scheduler.isEnabled()) {
            return ServletResourceUtils.buildReadResponse(() -> {
                List configs = AuthorizationUtils.filterByAuthorizedDatasources((HttpServletRequest)request, this.supervisorManager.getAllCompactionSupervisors(), supervisor -> supervisor.getSpec().getDataSource(), (AuthorizerMapper)this.authorizerMapper);
                return new CompactionConfigsResponse(configs.stream().map(CompactionSupervisorSpec::getSpec).collect(Collectors.toList()));
            });
        }
        return ServletResourceUtils.buildReadResponse(() -> {
            List configs = AuthorizationUtils.filterByAuthorizedDatasources((HttpServletRequest)request, (List)this.configManager.getCurrentCompactionConfig().getCompactionConfigs(), DataSourceCompactionConfig::getDataSource, (AuthorizerMapper)this.authorizerMapper);
            return new CompactionConfigsResponse(configs);
        });
    }

    @POST
    @Path(value="/config/datasources/{dataSource}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response updateDatasourceCompactionConfig(@PathParam(value="dataSource") String dataSource, DataSourceCompactionConfig newConfig, @Context HttpServletRequest request) {
        if (OverlordCompactionResource.isEmpty(dataSource)) {
            return OverlordCompactionResource.invalidInputResponse("No DataSource specified", new Object[0]);
        }
        if (!dataSource.equals(newConfig.getDataSource())) {
            return OverlordCompactionResource.invalidInputResponse("DataSource in spec[%s] does not match DataSource in path[%s]", newConfig.getDataSource(), dataSource);
        }
        if (this.scheduler.isEnabled()) {
            CompactionSupervisorSpec spec = new CompactionSupervisorSpec(newConfig, false, this.scheduler);
            return ServletResourceUtils.buildUpdateResponse(() -> this.supervisorManager.updateCompactionSupervisor(spec, request));
        }
        AuditInfo auditInfo = AuthorizationUtils.buildAuditInfo((HttpServletRequest)request);
        return ServletResourceUtils.buildUpdateResponse(() -> this.configManager.updateDatasourceCompactionConfig(newConfig, auditInfo));
    }

    @GET
    @Path(value="/config/datasources/{dataSource}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatasourceCompactionConfig(@PathParam(value="dataSource") String dataSource) {
        if (OverlordCompactionResource.isEmpty(dataSource)) {
            return OverlordCompactionResource.invalidInputResponse("No DataSource specified", new Object[0]);
        }
        if (this.scheduler.isEnabled()) {
            return ServletResourceUtils.buildReadResponse(() -> this.supervisorManager.getCompactionSupervisor(dataSource).getSpec());
        }
        return ServletResourceUtils.buildReadResponse(() -> this.configManager.getDatasourceCompactionConfig(dataSource));
    }

    @DELETE
    @Path(value="/config/datasources/{dataSource}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response deleteDatasourceCompactionConfig(@PathParam(value="dataSource") String dataSource, @Context HttpServletRequest req) {
        if (OverlordCompactionResource.isEmpty(dataSource)) {
            return OverlordCompactionResource.invalidInputResponse("No DataSource specified", new Object[0]);
        }
        if (this.scheduler.isEnabled()) {
            return ServletResourceUtils.buildUpdateResponse(() -> this.supervisorManager.deleteCompactionSupervisor(dataSource));
        }
        AuditInfo auditInfo = AuthorizationUtils.buildAuditInfo((HttpServletRequest)req);
        return ServletResourceUtils.buildUpdateResponse(() -> this.configManager.deleteDatasourceCompactionConfig(dataSource, auditInfo));
    }

    @GET
    @Path(value="/config/datasources/{dataSource}/history")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatasourceCompactionConfigHistory(@PathParam(value="dataSource") String dataSource, @QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        if (OverlordCompactionResource.isEmpty(dataSource)) {
            return OverlordCompactionResource.invalidInputResponse("No DataSource specified", new Object[0]);
        }
        if (this.scheduler.isEnabled()) {
            return ServletResourceUtils.buildReadResponse(() -> new CompactionConfigHistoryResponse(OverlordCompactionResource.filterByCountAndInterval(this.supervisorManager.getCompactionSupervisorHistory(dataSource), interval, count)));
        }
        return ServletResourceUtils.buildReadResponse(() -> new CompactionConfigHistoryResponse(this.configManager.getCompactionConfigHistory(dataSource, interval, count)));
    }

    @POST
    @Path(value="/simulate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response simulateRunWithConfigUpdate(ClusterCompactionConfig updatePayload) {
        return Response.ok().entity((Object)this.scheduler.simulateRunWithConfigUpdate(updatePayload)).build();
    }

    private static boolean isEmpty(String dataSource) {
        return dataSource == null || dataSource.isEmpty();
    }

    private static Response invalidInputResponse(String message, Object ... args) {
        return ServletResourceUtils.buildErrorResponseFrom((DruidException)InvalidInput.exception((String)message, (Object[])args));
    }

    private static <T> Response buildResponse(ListenableFuture<T> future) {
        try {
            return Response.ok((Object)FutureUtils.getUnchecked(future, (boolean)true)).build();
        }
        catch (Exception e) {
            if (e.getCause() instanceof HttpResponseException) {
                HttpResponseException cause = (HttpResponseException)e.getCause();
                return Response.status((int)cause.getResponse().getStatus().getCode()).entity((Object)cause.getResponse().getContent()).build();
            }
            return ServletResourceUtils.buildErrorResponseFrom((DruidException)InternalServerError.exception((String)e.getMessage(), (Object[])new Object[0]));
        }
    }

    private static List<DataSourceCompactionConfigAuditEntry> filterByCountAndInterval(List<DataSourceCompactionConfigAuditEntry> entries, @Nullable String serializedInterval, @Nullable Integer count) {
        Interval interval = serializedInterval == null || serializedInterval.isEmpty() ? null : Intervals.of((String)serializedInterval);
        return entries.stream().filter(entry -> interval == null || entry.getAuditTime() == null || interval.contains((ReadableInstant)entry.getAuditTime())).limit(count == null ? Integer.MAX_VALUE : (long)count.intValue()).collect(Collectors.toList());
    }
}

