/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.common.task.Task;

public class TaskLimits {
    public static final TaskLimits EMPTY = new TaskLimits();
    private final Map<String, Integer> maxSlotCountByType;
    private final Map<String, Double> maxSlotRatioByType;

    private TaskLimits() {
        this(Map.of(), Map.of());
    }

    @JsonCreator
    public TaskLimits(@JsonProperty(value="maxSlotCountByType") @Nullable Map<String, Integer> maxSlotCountByType, @JsonProperty(value="maxSlotRatioByType") @Nullable Map<String, Double> maxSlotRatioByType) {
        this.validateLimits(maxSlotCountByType, maxSlotRatioByType);
        this.maxSlotCountByType = (Map)Configs.valueOrDefault(maxSlotCountByType, Collections.emptyMap());
        this.maxSlotRatioByType = (Map)Configs.valueOrDefault(maxSlotRatioByType, Collections.emptyMap());
    }

    public boolean canRunTask(Task task, Integer currentSlotsUsed, Integer totalCapacity) {
        if (this.maxSlotRatioByType.isEmpty() && this.maxSlotCountByType.isEmpty()) {
            return true;
        }
        return this.meetsTaskLimit(task, currentSlotsUsed, totalCapacity);
    }

    private boolean meetsTaskLimit(Task task, Integer currentSlotsUsed, Integer totalCapacity) {
        Integer limit = this.getLimitForTask(task.getType(), totalCapacity);
        if (limit == null) {
            return true;
        }
        int requiredCapacity = task.getTaskResource().getRequiredCapacity();
        return this.hasCapacityBasedOnLimit(limit, currentSlotsUsed, requiredCapacity);
    }

    private Integer getLimitForTask(String taskType, Integer totalCapacity) {
        Integer absoluteLimit = this.maxSlotCountByType.get(taskType);
        Double ratioLimit = this.maxSlotRatioByType.get(taskType);
        if (absoluteLimit == null && ratioLimit == null) {
            return null;
        }
        if (ratioLimit != null) {
            int ratioBasedLimit = this.calculateTaskCapacityFromRatio(ratioLimit, totalCapacity);
            if (absoluteLimit != null) {
                return Math.min(absoluteLimit, ratioBasedLimit);
            }
            return ratioBasedLimit;
        }
        return absoluteLimit;
    }

    private boolean hasCapacityBasedOnLimit(int limit, int currentCapacityUsed, int requiredCapacity) {
        return limit - currentCapacityUsed >= requiredCapacity;
    }

    private int calculateTaskCapacityFromRatio(double taskSlotRatio, int totalCapacity) {
        int workerParallelIndexCapacity = (int)Math.floor(taskSlotRatio * (double)totalCapacity);
        return Math.max(1, Math.min(workerParallelIndexCapacity, totalCapacity));
    }

    private void validateLimits(Map<String, Integer> taskCountLimits, Map<String, Double> taskRatios) {
        if (taskCountLimits != null && taskCountLimits.values().stream().anyMatch(val -> val < 0)) {
            throw InvalidInput.exception((String)"Max task slot count limit for any type must be greater than zero. Found[%s].", (Object[])new Object[]{taskCountLimits});
        }
        if (taskRatios != null && taskRatios.values().stream().anyMatch(val -> val < 0.0 || val > 1.0)) {
            throw InvalidInput.exception((String)"Max task slot ratios should be in the interval of [0, 1]. Found[%s].", (Object[])new Object[]{taskCountLimits});
        }
    }

    @JsonProperty
    public Map<String, Integer> getMaxSlotCountByType() {
        return this.maxSlotCountByType;
    }

    @JsonProperty
    public Map<String, Double> getMaxSlotRatioByType() {
        return this.maxSlotRatioByType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLimits that = (TaskLimits)o;
        return Objects.equals(this.maxSlotCountByType, that.maxSlotCountByType) && Objects.equals(this.maxSlotRatioByType, that.maxSlotRatioByType);
    }

    public int hashCode() {
        return Objects.hash(this.maxSlotCountByType, this.maxSlotRatioByType);
    }

    public String toString() {
        return "TaskLimits{maxSlotCountByType=" + String.valueOf(this.maxSlotCountByType) + ", maxSlotRatioByType=" + String.valueOf(this.maxSlotRatioByType) + "}";
    }
}

