/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.netty.util.SuppressForbidden;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.cli.QueryJettyServerInitializer;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.curator.ZkEnablementConfig;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.CacheModule;
import org.apache.druid.guice.IndexingServiceInputSourceModule;
import org.apache.druid.guice.IndexingServiceTaskLogsModule;
import org.apache.druid.guice.IndexingServiceTuningConfigModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JoinableFactoryModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.ManageLifecycleServer;
import org.apache.druid.guice.PeonProcessingModule;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.QueryablePeonModule;
import org.apache.druid.guice.SegmentWranglerModule;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.guice.annotations.AttemptId;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Parent;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexer.report.SingleFileTaskReportFileWriter;
import org.apache.druid.indexer.report.TaskReportFileWriter;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.TaskToolboxFactory;
import org.apache.druid.indexing.common.actions.LocalTaskActionClientFactory;
import org.apache.druid.indexing.common.actions.RemoteTaskActionClientFactory;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStorageShuffleClient;
import org.apache.druid.indexing.common.task.batch.parallel.HttpShuffleClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientProvider;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientProviderImpl;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.indexing.overlord.HeapMemoryTaskStorage;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.SingleTaskBackgroundRunner;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.worker.executor.ExecutorLifecycle;
import org.apache.druid.indexing.worker.executor.ExecutorLifecycleConfig;
import org.apache.druid.indexing.worker.shuffle.DeepStorageIntermediaryDataManager;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.indexing.worker.shuffle.LocalIntermediaryDataManager;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.lookup.LookupModule;
import org.apache.druid.segment.handoff.CoordinatorBasedSegmentHandoffNotifierConfig;
import org.apache.druid.segment.handoff.CoordinatorBasedSegmentHandoffNotifierFactory;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.OmniDataSegmentArchiver;
import org.apache.druid.segment.loading.OmniDataSegmentKiller;
import org.apache.druid.segment.loading.OmniDataSegmentMover;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.realtime.ChatHandlerProvider;
import org.apache.druid.segment.realtime.NoopChatHandlerProvider;
import org.apache.druid.segment.realtime.ServiceAnnouncingChatHandlerProvider;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.PeonAppenderatorsManager;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.BroadcastDatasourceLoadingSpec;
import org.apache.druid.server.coordination.SegmentBootstrapper;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.ZkCoordinator;
import org.apache.druid.server.http.HistoricalResource;
import org.apache.druid.server.http.SegmentListerResource;
import org.apache.druid.server.initialization.jetty.ChatHandlerServerModule;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.apache.druid.storage.local.LocalTmpStorageConfig;
import org.apache.druid.tasklogs.TaskPayloadManager;
import org.eclipse.jetty.server.Server;

@Command(name="peon", description="Runs a Peon, this is an individual forked \"task\" used as part of the indexing service. This should rarely, if ever, be used directly. See https://druid.apache.org/docs/latest/design/peons.html for a description")
public class CliPeon
extends GuiceRunnable {
    @Required
    @Arguments(description="taskDirPath attemptId")
    public List<String> taskAndStatusFile;
    private String taskDirPath;
    private String attemptId;
    @Option(name={"--nodeType"}, title={"nodeType"}, description="Set the node type to expose on ZK")
    public String serverType = "indexer-executor";
    private boolean isZkEnabled = true;
    @Deprecated
    @Option(name={"--loadBroadcastSegments"}, title={"loadBroadcastSegments"}, description="Enable loading of broadcast segments. This option is deprecated and will be removed in a future release. Use --loadBroadcastDatasourceMode instead.")
    public String loadBroadcastSegments = "false";
    @Option(name={"--loadBroadcastDatasourceMode"}, title={"loadBroadcastDatasourceMode"}, description="Specify the broadcast datasource loading mode for the peon. Supported values are ALL, NONE, ONLY_REQUIRED.")
    public String loadBroadcastDatasourcesMode = BroadcastDatasourceLoadingSpec.Mode.ALL.toString();
    @Option(name={"--taskId"}, title={"taskId"}, description="TaskId for fetching task.json remotely")
    public String taskId = "";
    private static final Logger log = new Logger(CliPeon.class);
    private Properties properties;

    public CliPeon() {
        super(log);
    }

    @Inject
    public void configure(Properties properties) {
        this.properties = properties;
        this.isZkEnabled = ZkEnablementConfig.isEnabled((Properties)properties);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new PeonProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new SegmentWranglerModule(), (Object)new JoinableFactoryModule(), (Object)new IndexingServiceTaskLogsModule(), (Object)new Module(){

            @SuppressForbidden(reason="System#out, System#err")
            public void configure(Binder binder) {
                ServerRunnable.validateCentralizedDatasourceSchemaConfig(CliPeon.this.getProperties());
                Preconditions.checkArgument((CliPeon.this.taskAndStatusFile.size() >= 2 ? 1 : 0) != 0, (String)"taskAndStatusFile array should contain 2 or more elements. Current array elements: [%s]", (Object)CliPeon.this.taskAndStatusFile.toString());
                CliPeon.this.taskDirPath = CliPeon.this.taskAndStatusFile.get(0);
                CliPeon.this.attemptId = CliPeon.this.taskAndStatusFile.get(1);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.centralizedDatasourceSchema", CentralizedDatasourceSchemaConfig.class);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/peon");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                binder.bind(ResponseContextConfig.class).toInstance((Object)ResponseContextConfig.newConfig((boolean)true));
                binder.bindConstant().annotatedWith(AttemptId.class).to(CliPeon.this.attemptId);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.task.executor", DruidNode.class, Parent.class);
                CliPeon.bindRowIngestionMeters(binder);
                CliPeon.bindChatHandler(binder);
                CliPeon.configureIntermediaryData(binder);
                CliPeon.bindTaskConfigAndClients(binder);
                CliPeon.bindPeonDataSegmentHandlers(binder);
                binder.bind(ExecutorLifecycle.class).in(ManageLifecycle.class);
                LifecycleModule.register((Binder)binder, ExecutorLifecycle.class);
                ExecutorLifecycleConfig executorLifecycleConfig = new ExecutorLifecycleConfig().setTaskFile(Paths.get(CliPeon.this.taskDirPath, "task.json").toFile()).setStatusFile(Paths.get(CliPeon.this.taskDirPath, "attempt", CliPeon.this.attemptId, "status.json").toFile());
                if (CliPeon.this.properties.getProperty("druid.indexer.runner.type", "").contains("k8s")) {
                    log.info("Running peon in k8s mode", new Object[0]);
                    executorLifecycleConfig.setParentStreamDefined(false);
                }
                binder.bind(ExecutorLifecycleConfig.class).toInstance((Object)executorLifecycleConfig);
                binder.bind(TaskReportFileWriter.class).toInstance((Object)new SingleFileTaskReportFileWriter(Paths.get(CliPeon.this.taskDirPath, "attempt", CliPeon.this.attemptId, "report.json").toFile()));
                binder.bind(TaskRunner.class).to(SingleTaskBackgroundRunner.class);
                binder.bind(QuerySegmentWalker.class).to(SingleTaskBackgroundRunner.class);
                binder.bind(SingleTaskBackgroundRunner.class).in(ManageLifecycleServer.class);
                CliPeon.bindRealtimeCache(binder);
                CliPeon.bindCoordinatorHandoffNotifer(binder);
                binder.bind(AppenderatorsManager.class).to(PeonAppenderatorsManager.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, SegmentListerResource.class);
                binder.bind(ServerTypeConfig.class).toInstance((Object)new ServerTypeConfig(ServerType.fromString((String)CliPeon.this.serverType)));
                LifecycleModule.register((Binder)binder, Server.class);
                BroadcastDatasourceLoadingSpec.Mode mode = BroadcastDatasourceLoadingSpec.Mode.valueOf((String)CliPeon.this.loadBroadcastDatasourcesMode);
                if ("true".equals(CliPeon.this.loadBroadcastSegments) || mode == BroadcastDatasourceLoadingSpec.Mode.ALL || mode == BroadcastDatasourceLoadingSpec.Mode.ONLY_REQUIRED) {
                    binder.install((Module)new BroadcastSegmentLoadingModule());
                }
            }

            @Provides
            @LazySingleton
            @Named(value="heartbeat")
            public Supplier<Map<String, Object>> heartbeatDimensions(Task task) {
                return () -> CliPeon.heartbeatDimensions(task);
            }

            @Provides
            @LazySingleton
            public Task readTask(@Json ObjectMapper mapper, ExecutorLifecycleConfig config, TaskPayloadManager taskPayloadManager) {
                try {
                    if (!config.getTaskFile().exists() || config.getTaskFile().length() == 0L) {
                        log.info("Task file not found, trying to pull task payload from deep storage", new Object[0]);
                        String task = IOUtils.toString((InputStream)((InputStream)taskPayloadManager.streamTaskPayload(CliPeon.this.taskId).get()), (Charset)Charset.defaultCharset());
                        FileUtils.write((File)config.getTaskFile(), (CharSequence)task, (Charset)Charset.defaultCharset());
                    }
                    return (Task)mapper.readValue(config.getTaskFile(), Task.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Provides
            @LazySingleton
            @Named(value="druidDataSource")
            public String getDataSourceFromTask(Task task) {
                return task.getDataSource();
            }

            @Provides
            @LazySingleton
            @Named(value="druidTaskId")
            public String getTaskIDFromTask(Task task) {
                return task.getId();
            }

            @Provides
            @LazySingleton
            @Named(value="lookupsToLoadForTask")
            public LookupLoadingSpec getLookupsToLoad(Task task) {
                return task.getLookupLoadingSpec();
            }

            @Provides
            @LazySingleton
            @Named(value="broadcastDatasourcesToLoadForTask")
            public BroadcastDatasourceLoadingSpec getBroadcastDatasourcesToLoad(Task task) {
                return task.getBroadcastDatasourceLoadingSpec();
            }

            @Provides
            @LazySingleton
            public LocalTmpStorageConfig getLocalTmpStorage() {
                File tmpDir = new File(CliPeon.this.taskDirPath, "tmp");
                try {
                    org.apache.druid.java.util.common.FileUtils.mkdirp((File)tmpDir);
                }
                catch (IOException e) {
                    log.error("Failed to create tmp directory for the task", new Object[0]);
                    throw new RuntimeException(e);
                }
                return () -> tmpDir;
            }
        }, (Object)new QueryablePeonModule(), (Object)new IndexingServiceInputSourceModule(), (Object)new IndexingServiceTuningConfigModule(), (Object)new InputSourceModule(), (Object)new ChatHandlerServerModule(this.properties), (Object[])new Module[]{new LookupModule()});
    }

    @Override
    @SuppressForbidden(reason="System#out, System#err")
    public void run() {
        try {
            Injector injector = this.makeInjector((Set<NodeRole>)ImmutableSet.of((Object)NodeRole.PEON));
            try {
                Lifecycle lifecycle = this.initLifecycle(injector);
                Thread hook = new Thread(() -> {
                    log.info("Running shutdown hook", new Object[0]);
                    lifecycle.stop();
                });
                Runtime.getRuntime().addShutdownHook(hook);
                ((ExecutorLifecycle)injector.getInstance(ExecutorLifecycle.class)).join();
                Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
                for (Thread thread : threadSet) {
                    if (thread.isDaemon() || thread == Thread.currentThread()) continue;
                    log.info("Thread [%s] is non daemon.", new Object[]{thread});
                }
                lifecycle.stop();
                try {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
                catch (IllegalStateException e) {
                    System.err.println("Cannot remove shutdown hook, already shutting down!");
                }
            }
            catch (Throwable t) {
                System.err.println("Error!");
                System.err.println(Throwables.getStackTraceAsString((Throwable)t));
                System.exit(1);
            }
            System.out.println("Finished peon task");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static void bindRowIngestionMeters(Binder binder) {
        PolyBind.createChoice((Binder)binder, (String)"druid.indexer.task.rowIngestionMeters.type", (Key)Key.get(RowIngestionMetersFactory.class), (Key)Key.get(DropwizardRowIngestionMetersFactory.class));
        MapBinder rowIngestionMetersHandlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(RowIngestionMetersFactory.class));
        rowIngestionMetersHandlerProviderBinder.addBinding((Object)"dropwizard").to(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
        binder.bind(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
    }

    static void bindChatHandler(Binder binder) {
        PolyBind.createChoice((Binder)binder, (String)"druid.indexer.task.chathandler.type", (Key)Key.get(ChatHandlerProvider.class), (Key)Key.get(ServiceAnnouncingChatHandlerProvider.class));
        MapBinder handlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ChatHandlerProvider.class));
        handlerProviderBinder.addBinding((Object)"announce").to(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
        handlerProviderBinder.addBinding((Object)"noop").to(NoopChatHandlerProvider.class).in(LazySingleton.class);
        binder.bind(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
        binder.bind(NoopChatHandlerProvider.class).in(LazySingleton.class);
    }

    static void bindPeonDataSegmentHandlers(Binder binder) {
        Binders.dataSegmentKillerBinder((Binder)binder);
        binder.bind(DataSegmentKiller.class).to(OmniDataSegmentKiller.class).in(LazySingleton.class);
        Binders.dataSegmentMoverBinder((Binder)binder);
        binder.bind(DataSegmentMover.class).to(OmniDataSegmentMover.class).in(LazySingleton.class);
        Binders.dataSegmentArchiverBinder((Binder)binder);
        binder.bind(DataSegmentArchiver.class).to(OmniDataSegmentArchiver.class).in(LazySingleton.class);
    }

    private static void configureTaskActionClient(Binder binder) {
        PolyBind.createChoice((Binder)binder, (String)"druid.peon.mode", (Key)Key.get(TaskActionClientFactory.class), (Key)Key.get(RemoteTaskActionClientFactory.class));
        MapBinder taskActionBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskActionClientFactory.class));
        taskActionBinder.addBinding((Object)"local").to(LocalTaskActionClientFactory.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.storage", TaskStorageConfig.class);
        binder.bind(TaskStorage.class).to(HeapMemoryTaskStorage.class).in(LazySingleton.class);
        binder.bind(TaskActionToolbox.class).in(LazySingleton.class);
        binder.bind(IndexerMetadataStorageCoordinator.class).to(IndexerSQLMetadataStorageCoordinator.class).in(LazySingleton.class);
        taskActionBinder.addBinding((Object)"remote").to(RemoteTaskActionClientFactory.class).in(LazySingleton.class);
        binder.bind(NodeRole.class).annotatedWith(Self.class).toInstance((Object)NodeRole.PEON);
    }

    static void bindTaskConfigAndClients(Binder binder) {
        binder.bind(TaskToolboxFactory.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.peon.taskActionClient.retry", RetryPolicyConfig.class);
        CliPeon.configureTaskActionClient(binder);
        binder.bind(ParallelIndexSupervisorTaskClientProvider.class).to(ParallelIndexSupervisorTaskClientProviderImpl.class).in(LazySingleton.class);
        binder.bind(RetryPolicyFactory.class).in(LazySingleton.class);
    }

    static void bindRealtimeCache(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.realtime.cache", CacheConfig.class);
        binder.install((Module)new CacheModule());
    }

    static void bindCoordinatorHandoffNotifer(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.segment.handoff", CoordinatorBasedSegmentHandoffNotifierConfig.class);
        binder.bind(SegmentHandoffNotifierFactory.class).to(CoordinatorBasedSegmentHandoffNotifierFactory.class).in(LazySingleton.class);
    }

    static void configureIntermediaryData(Binder binder) {
        PolyBind.createChoice((Binder)binder, (String)"druid.processing.intermediaryData.storage.type", (Key)Key.get(IntermediaryDataManager.class), (Key)Key.get(LocalIntermediaryDataManager.class));
        MapBinder intermediaryDataManagerBiddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(IntermediaryDataManager.class));
        intermediaryDataManagerBiddy.addBinding((Object)"local").to(LocalIntermediaryDataManager.class).in(LazySingleton.class);
        intermediaryDataManagerBiddy.addBinding((Object)"deepstore").to(DeepStorageIntermediaryDataManager.class).in(LazySingleton.class);
        PolyBind.createChoice((Binder)binder, (String)"druid.processing.intermediaryData.storage.type", (Key)Key.get(ShuffleClient.class), (Key)Key.get(HttpShuffleClient.class));
        MapBinder shuffleClientBiddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ShuffleClient.class));
        shuffleClientBiddy.addBinding((Object)"local").to(HttpShuffleClient.class).in(LazySingleton.class);
        shuffleClientBiddy.addBinding((Object)"deepstore").to(DeepStorageShuffleClient.class).in(LazySingleton.class);
    }

    static Map<String, Object> heartbeatDimensions(Task task) {
        SeekableStreamIndexTask streamingTask;
        String status;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"taskId", (Object)task.getId());
        builder.put((Object)"dataSource", (Object)task.getDataSource());
        builder.put((Object)"taskType", (Object)task.getType());
        builder.put((Object)"groupId", (Object)task.getGroupId());
        Map tags = (Map)task.getContextValue("tags");
        if (tags != null && !tags.isEmpty()) {
            builder.put((Object)"tags", (Object)tags);
        }
        if (task instanceof SeekableStreamIndexTask && (status = (streamingTask = (SeekableStreamIndexTask)task).getCurrentRunnerStatus()) != null) {
            builder.put((Object)"status", (Object)status);
        }
        return builder.build();
    }

    public class BroadcastSegmentLoadingModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(SegmentManager.class).in(LazySingleton.class);
            binder.bind(ZkCoordinator.class).in(ManageLifecycle.class);
            Jerseys.addResource((Binder)binder, HistoricalResource.class);
            if (CliPeon.this.isZkEnabled) {
                LifecycleModule.register((Binder)binder, ZkCoordinator.class);
            }
            LifecycleModule.register((Binder)binder, SegmentBootstrapper.class);
        }

        @Provides
        @LazySingleton
        public List<StorageLocation> getCliPeonStorageLocations(TaskConfig config) {
            File broadcastStorage = new File(new File(CliPeon.this.taskDirPath, "broadcast"), "segments");
            return ImmutableList.of((Object)new StorageLocation(broadcastStorage, config.getTmpStorageBytesPerTask(), null));
        }
    }
}

