/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.k8s.overlord.common.DruidK8sConstants;
import org.apache.druid.k8s.overlord.common.JobResponse;
import org.apache.druid.k8s.overlord.common.K8sTaskId;
import org.apache.druid.k8s.overlord.common.KubernetesClientApi;
import org.apache.druid.k8s.overlord.common.KubernetesResourceNotFoundException;
import org.apache.druid.k8s.overlord.common.PeonPhase;

public class KubernetesPeonClient {
    private static final EmittingLogger log = new EmittingLogger(KubernetesPeonClient.class);
    private final KubernetesClientApi clientApi;
    private final String namespace;
    private final String overlordNamespace;
    private final boolean debugJobs;
    private final ServiceEmitter emitter;

    public KubernetesPeonClient(KubernetesClientApi clientApi, String namespace, String overlordNamespace, boolean debugJobs, ServiceEmitter emitter) {
        this.clientApi = clientApi;
        this.namespace = namespace;
        this.overlordNamespace = overlordNamespace;
        this.debugJobs = debugJobs;
        this.emitter = emitter;
    }

    public KubernetesPeonClient(KubernetesClientApi clientApi, String namespace, boolean debugJobs, ServiceEmitter emitter) {
        this(clientApi, namespace, "", debugJobs, emitter);
    }

    public Pod launchPeonJobAndWaitForStart(Job job, Task task, long howLong, TimeUnit timeUnit) throws IllegalStateException {
        long start = System.currentTimeMillis();
        return this.clientApi.executeRequest(client -> {
            ((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).resource((Object)job)).create();
            String jobName = job.getMetadata().getName();
            log.info("Successfully submitted job: %s ... waiting for job to launch", new Object[]{jobName});
            Pod mainPod = this.getPeonPodWithRetries(jobName);
            Pod result = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withName(mainPod.getMetadata().getName())).waitUntilCondition(pod -> {
                if (pod == null) {
                    return true;
                }
                return pod.getStatus() != null && pod.getStatus().getPodIP() != null;
            }, howLong, timeUnit);
            if (result == null) {
                throw new IllegalStateException("K8s pod for the task [%s] appeared and disappeared. It can happen if the task was canceled");
            }
            long duration = System.currentTimeMillis() - start;
            this.emitK8sPodMetrics(task, "k8s/peon/startup/time", duration);
            return result;
        });
    }

    public JobResponse waitForPeonJobCompletion(K8sTaskId taskId, long howLong, TimeUnit unit) {
        return this.clientApi.executeRequest(client -> {
            Job job = (Job)((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withName(taskId.getK8sJobName())).waitUntilCondition(x -> x == null || x.getStatus() != null && x.getStatus().getActive() == null && (x.getStatus().getFailed() != null || x.getStatus().getSucceeded() != null), howLong, unit);
            if (job == null) {
                log.info("K8s job for the task [%s] was not found. It can happen if the task was canceled", new Object[]{taskId});
                return new JobResponse(null, PeonPhase.FAILED);
            }
            if (job.getStatus().getSucceeded() != null) {
                return new JobResponse(job, PeonPhase.SUCCEEDED);
            }
            log.warn("Task %s failed with status %s", new Object[]{taskId, job.getStatus()});
            return new JobResponse(job, PeonPhase.FAILED);
        });
    }

    public boolean deletePeonJob(K8sTaskId taskId) {
        if (!this.debugJobs) {
            Boolean result = this.clientApi.executeRequest(client -> !((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withName(taskId.getK8sJobName())).delete().isEmpty());
            if (result.booleanValue()) {
                log.info("Cleaned up k8s job: %s", new Object[]{taskId});
            } else {
                log.info("K8s job does not exist: %s", new Object[]{taskId});
            }
            return result;
        }
        log.info("Not cleaning up job %s due to flag: debugJobs=true", new Object[]{taskId});
        return true;
    }

    public Optional<LogWatch> getPeonLogWatcher(K8sTaskId taskId) {
        KubernetesClient k8sClient = this.clientApi.getClient();
        try {
            LogWatch logWatch = ((Loggable)((ScalableResource)((NonNamespaceOperation)k8sClient.batch().v1().jobs().inNamespace(this.namespace)).withName(taskId.getK8sJobName())).inContainer((Object)"main")).watchLog();
            if (logWatch == null) {
                return Optional.absent();
            }
            return Optional.of((Object)logWatch);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error watching logs from task: %s", new Object[]{taskId});
            return Optional.absent();
        }
    }

    public Optional<InputStream> getPeonLogs(K8sTaskId taskId) {
        KubernetesClient k8sClient = this.clientApi.getClient();
        try {
            InputStream logStream = ((Loggable)((ScalableResource)((NonNamespaceOperation)k8sClient.batch().v1().jobs().inNamespace(this.namespace)).withName(taskId.getK8sJobName())).inContainer((Object)"main")).getLogInputStream();
            if (logStream == null) {
                return Optional.absent();
            }
            return Optional.of((Object)logStream);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error streaming logs from task: %s", new Object[]{taskId});
            return Optional.absent();
        }
    }

    public List<Job> getPeonJobs() {
        return this.overlordNamespace.isEmpty() ? this.getPeonJobsWithoutOverlordNamespaceKeyLabels() : this.getPeonJobsWithOverlordNamespaceKeyLabels();
    }

    private List<Job> getPeonJobsWithoutOverlordNamespaceKeyLabels() {
        return this.clientApi.executeRequest(client -> ((JobList)((FilterWatchListDeletable)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withLabel("druid.k8s.peons")).list()).getItems());
    }

    private List<Job> getPeonJobsWithOverlordNamespaceKeyLabels() {
        return this.clientApi.executeRequest(client -> ((JobList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withLabel("druid.k8s.peons")).withLabel("druid.overlord.namespace", this.overlordNamespace)).list()).getItems());
    }

    public int deleteCompletedPeonJobsOlderThan(long howFarBack, TimeUnit timeUnit) {
        AtomicInteger numDeleted = new AtomicInteger();
        return this.clientApi.executeRequest(client -> {
            List<Job> jobs = this.getJobsToCleanup(this.getPeonJobs(), howFarBack, timeUnit);
            jobs.forEach(x -> {
                if (!((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withName(x.getMetadata().getName())).delete().isEmpty()) {
                    numDeleted.incrementAndGet();
                } else {
                    log.error("Failed to delete job %s", new Object[]{x.getMetadata().getName()});
                }
            });
            return numDeleted.get();
        });
    }

    private List<Job> getJobsToCleanup(List<Job> candidates, long howFarBack, TimeUnit timeUnit) {
        ArrayList<Job> toDelete = new ArrayList<Job>();
        long cutOff = System.currentTimeMillis() - timeUnit.toMillis(howFarBack);
        candidates.forEach(x -> {
            Timestamp timestamp;
            if (x.getStatus().getActive() == null && (timestamp = Timestamp.valueOf(x.getStatus().getCompletionTime())).before(new Timestamp(cutOff))) {
                toDelete.add((Job)x);
            }
        });
        return toDelete;
    }

    public Optional<Pod> getPeonPod(String jobName) {
        return this.clientApi.executeRequest(client -> this.getPeonPod(client, jobName));
    }

    private Optional<Pod> getPeonPod(KubernetesClient client, String jobName) {
        List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withLabel("job-name", jobName)).list()).getItems();
        return pods.isEmpty() ? Optional.absent() : Optional.of((Object)((Pod)pods.get(0)));
    }

    public Pod getPeonPodWithRetries(String jobName) {
        return this.clientApi.executeRequest(client -> this.getPeonPodWithRetries(client, jobName, 5, 10));
    }

    @VisibleForTesting
    Pod getPeonPodWithRetries(KubernetesClient client, String jobName, int quietTries, int maxTries) {
        try {
            return (Pod)RetryUtils.retry(() -> {
                Optional<Pod> maybePod = this.getPeonPod(client, jobName);
                if (maybePod.isPresent()) {
                    return (Pod)maybePod.get();
                }
                throw new KubernetesResourceNotFoundException("K8s pod with label: job-name=" + jobName + " not found");
            }, DruidK8sConstants.IS_TRANSIENT, (int)quietTries, (int)maxTries);
        }
        catch (Exception e) {
            throw DruidException.defensive((Throwable)e, (String)"Error when looking for K8s pod with label[job-name=%s]", (Object[])new Object[]{jobName});
        }
    }

    private void emitK8sPodMetrics(Task task, String metric, long durationMs) {
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
        IndexTaskUtils.setTaskDimensions((ServiceMetricEvent.Builder)metricBuilder, (Task)task);
        this.emitter.emit((ServiceEventBuilder)metricBuilder.setMetric(metric, (Number)durationMs));
    }
}

