/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.taskadapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.apache.druid.k8s.overlord.common.Base64Compression;
import org.apache.druid.k8s.overlord.common.K8sTaskId;
import org.apache.druid.k8s.overlord.common.KubernetesClientApi;
import org.apache.druid.k8s.overlord.common.PeonCommandContext;
import org.apache.druid.k8s.overlord.taskadapter.K8sTaskAdapter;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.tasklogs.TaskLogs;

public class SingleContainerTaskAdapter
extends K8sTaskAdapter {
    public static final String TYPE = "overlordSingleContainer";

    public SingleContainerTaskAdapter(KubernetesClientApi client, KubernetesTaskRunnerConfig taskRunnerConfig, TaskConfig taskConfig, StartupLoggingConfig startupLoggingConfig, DruidNode druidNode, ObjectMapper mapper, TaskLogs taskLogs) {
        super(client, taskRunnerConfig, taskConfig, startupLoggingConfig, druidNode, mapper, taskLogs);
    }

    @Override
    public String getAdapterType() {
        return TYPE;
    }

    @Override
    Job createJobFromPodSpec(PodSpec podSpec, Task task, PeonCommandContext context) throws IOException {
        K8sTaskId k8sTaskId = new K8sTaskId(this.taskRunnerConfig.getK8sTaskPodNamePrefix(), task.getId());
        long containerSize = SingleContainerTaskAdapter.getContainerMemory(context);
        String taskContents = Base64Compression.compressBase64(this.mapper.writeValueAsString((Object)task));
        Container mainContainer = this.setupMainContainer(podSpec, context, containerSize, taskContents);
        Map<String, String> annotations = this.addJobSpecificAnnotations(context, k8sTaskId);
        Map<String, String> labels = this.addJobSpecificLabels();
        podSpec.setContainers(Collections.singletonList(mainContainer));
        return this.buildJob(k8sTaskId, labels, annotations, this.createTemplateFromSpec(k8sTaskId, podSpec, annotations, labels));
    }
}

