/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.io.IOException;
import java.text.ParseException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.pac4j.OIDCConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.pac4j.oidc.profile.creator.TokenValidator;

public class JwtAuthFilter
implements Filter {
    private static final Logger LOG = new Logger(JwtAuthFilter.class);
    private final String authorizerName;
    private final String name;
    private final OIDCConfig oidcConfig;
    private final TokenValidator tokenValidator;

    public JwtAuthFilter(String authorizerName, String name, OIDCConfig oidcConfig, TokenValidator tokenValidator) {
        this.authorizerName = authorizerName;
        this.name = name;
        this.oidcConfig = oidcConfig;
        this.tokenValidator = tokenValidator;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block5: {
            if (servletRequest.getAttribute("Druid-Authentication-Result") != null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            Optional<String> idToken = JwtAuthFilter.extractBearerToken(httpServletRequest);
            if (idToken.isPresent()) {
                try {
                    IDTokenClaimsSet claims = this.tokenValidator.validate(JWTParser.parse((String)idToken.get()), null);
                    if (claims == null) break block5;
                    Optional<String> claim = Optional.ofNullable(claims.getStringClaim(this.oidcConfig.getOidcClaim()));
                    if (claim.isPresent()) {
                        LOG.debug("Authentication successful for " + this.oidcConfig.getClientID(), new Object[0]);
                        AuthenticationResult authenticationResult = new AuthenticationResult(claim.get(), this.authorizerName, this.name, null);
                        servletRequest.setAttribute("Druid-Authentication-Result", (Object)authenticationResult);
                        break block5;
                    }
                    LOG.error("Authentication failed! Please ensure that the ID token is valid and it contains the configured claim.", new Object[0]);
                    httpServletResponse.sendError(401);
                    return;
                }
                catch (JOSEException | BadJOSEException | ParseException e) {
                    LOG.error(e, "Failed to parse JWT token", new Object[0]);
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private static Optional<String> extractBearerToken(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer ")) {
            LOG.debug("Request does not contain bearer authentication scheme", new Object[0]);
            return Optional.empty();
        }
        String headerWithoutPrefix = header.substring("Bearer ".length());
        return Optional.of(headerWithoutPrefix);
    }
}

