/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import java.util.Map;
import org.apache.druid.guice.DruidBinders;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.segment.FrameBasedInlineSegmentWrangler;
import org.apache.druid.segment.InlineSegmentWrangler;
import org.apache.druid.segment.LookupSegmentWrangler;
import org.apache.druid.segment.MapSegmentWrangler;
import org.apache.druid.segment.SegmentWrangler;

public class SegmentWranglerModule
implements Module {
    @VisibleForTesting
    static final Map<Class<? extends DataSource>, Class<? extends SegmentWrangler>> WRANGLER_MAPPINGS = ImmutableMap.of(InlineDataSource.class, InlineSegmentWrangler.class, FrameBasedInlineDataSource.class, FrameBasedInlineSegmentWrangler.class, LookupDataSource.class, LookupSegmentWrangler.class);

    public void configure(Binder binder) {
        MapBinder<Class<? extends DataSource>, SegmentWrangler> segmentWranglers = DruidBinders.segmentWranglerBinder(binder);
        WRANGLER_MAPPINGS.forEach((ds, wrangler) -> {
            segmentWranglers.addBinding(ds).to(wrangler);
            binder.bind(wrangler).in(LazySingleton.class);
        });
        binder.bind(SegmentWrangler.class).to(MapSegmentWrangler.class).in(Scopes.SINGLETON);
    }
}

