/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.sql.ResultSet;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class PendingSegmentRecord {
    private final SegmentIdWithShardSpec id;
    private final String sequenceName;
    private final String sequencePrevId;
    private final String upgradedFromSegmentId;
    private final String taskAllocatorId;
    private final DateTime createdDate;

    @JsonCreator
    public static PendingSegmentRecord fromJson(@JsonProperty(value="id") SegmentIdWithShardSpec id, @JsonProperty(value="sequenceName") String sequenceName, @JsonProperty(value="sequencePrevId") String sequencePrevId, @JsonProperty(value="upgradedFromSegmentId") @Nullable String upgradedFromSegmentId, @JsonProperty(value="taskAllocatorId") @Nullable String taskAllocatorId) {
        return new PendingSegmentRecord(id, sequenceName, sequencePrevId, upgradedFromSegmentId, taskAllocatorId, DateTimes.EPOCH);
    }

    public PendingSegmentRecord(SegmentIdWithShardSpec id, String sequenceName, String sequencePrevId, String upgradedFromSegmentId, String taskAllocatorId, DateTime createdDate) {
        this.id = id;
        this.sequenceName = sequenceName;
        this.sequencePrevId = sequencePrevId == null ? "" : sequencePrevId;
        this.upgradedFromSegmentId = upgradedFromSegmentId;
        this.taskAllocatorId = taskAllocatorId;
        this.createdDate = createdDate;
    }

    @JsonProperty
    public SegmentIdWithShardSpec getId() {
        return this.id;
    }

    @JsonProperty
    public String getSequenceName() {
        return this.sequenceName;
    }

    @JsonProperty
    public String getSequencePrevId() {
        return this.sequencePrevId;
    }

    @Nullable
    @JsonProperty
    public String getUpgradedFromSegmentId() {
        return this.upgradedFromSegmentId;
    }

    @Nullable
    @JsonProperty
    public String getTaskAllocatorId() {
        return this.taskAllocatorId;
    }

    @JsonIgnore
    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public String computeSequenceNamePrevIdSha1(boolean skipSegmentLineageCheck) {
        Hasher hasher = Hashing.sha1().newHasher().putBytes(StringUtils.toUtf8((String)this.getSequenceName())).putByte((byte)-1);
        if (skipSegmentLineageCheck) {
            Interval interval = this.getId().getInterval();
            hasher.putLong(interval.getStartMillis()).putLong(interval.getEndMillis());
        } else {
            hasher.putBytes(StringUtils.toUtf8((String)this.getSequencePrevId()));
        }
        hasher.putByte((byte)-1);
        hasher.putBytes(StringUtils.toUtf8((String)this.getId().getVersion()));
        return BaseEncoding.base16().encode(hasher.hash().asBytes());
    }

    public static PendingSegmentRecord create(SegmentIdWithShardSpec id, String sequenceName, String sequencePrevId, @Nullable String upgradedFromSegmentId, @Nullable String taskAllocatorId) {
        return new PendingSegmentRecord(id, sequenceName, sequencePrevId, upgradedFromSegmentId, taskAllocatorId, DateTimes.nowUtc());
    }

    public static PendingSegmentRecord fromResultSet(ResultSet resultSet, ObjectMapper jsonMapper) {
        try {
            byte[] payload = resultSet.getBytes("payload");
            return new PendingSegmentRecord((SegmentIdWithShardSpec)jsonMapper.readValue(payload, SegmentIdWithShardSpec.class), resultSet.getString("sequence_name"), resultSet.getString("sequence_prev_id"), resultSet.getString("upgraded_from_segment_id"), resultSet.getString("task_allocator_id"), DateTimes.of((String)resultSet.getString("created_date")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

