/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;

public class OmniDataSegmentMover
implements DataSegmentMover {
    private final Map<String, Supplier<DataSegmentMover>> movers = new HashMap<String, Supplier<DataSegmentMover>>();

    @Inject
    public OmniDataSegmentMover(Map<String, Provider<DataSegmentMover>> movers) {
        for (Map.Entry<String, Provider<DataSegmentMover>> entry : movers.entrySet()) {
            String type = entry.getKey();
            Provider<DataSegmentMover> provider = entry.getValue();
            this.movers.put(type, (Supplier<DataSegmentMover>)Suppliers.memoize(() -> provider.get()));
        }
    }

    public DataSegment move(DataSegment segment, Map<String, Object> targetLoadSpec) throws SegmentLoadingException {
        return this.getMover(segment).move(segment, targetLoadSpec);
    }

    private DataSegmentMover getMover(DataSegment segment) throws SegmentLoadingException {
        String type = MapUtils.getString((Map)segment.getLoadSpec(), (String)"type");
        Supplier<DataSegmentMover> mover = this.movers.get(type);
        if (mover == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", new Object[]{type, this.movers.keySet()});
        }
        return (DataSegmentMover)mover.get();
    }

    @VisibleForTesting
    public Map<String, Supplier<DataSegmentMover>> getMovers() {
        return this.movers;
    }
}

