/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.timeline.DataSegment;

public class StorageLocation {
    private static final EmittingLogger log = new EmittingLogger(StorageLocation.class);
    private final File path;
    private final long maxSizeBytes;
    private final long freeSpaceToKeep;
    @GuardedBy(value="this")
    private final Set<File> files = new HashSet<File>();
    @GuardedBy(value="this")
    private long currSizeBytes = 0L;

    public StorageLocation(File path, long maxSizeBytes, @Nullable Double freeSpacePercent) {
        this.path = path;
        this.maxSizeBytes = maxSizeBytes;
        if (freeSpacePercent != null) {
            long totalSpaceInPartition = path.getTotalSpace();
            this.freeSpaceToKeep = (long)(freeSpacePercent * (double)totalSpaceInPartition / 100.0);
            log.info("SegmentLocation[%s] will try and maintain [%d:%d] free space while loading segments.", new Object[]{path, this.freeSpaceToKeep, totalSpaceInPartition});
        } else {
            this.freeSpaceToKeep = 0L;
        }
    }

    public File getPath() {
        return this.path;
    }

    public synchronized void removeFile(File file) {
        if (this.files.remove(file)) {
            this.currSizeBytes -= FileUtils.sizeOf((File)file);
        } else {
            log.warn("File[%s] is not found under this location[%s]", new Object[]{file, this.path});
        }
    }

    public synchronized void removeSegmentDir(File segmentDir, DataSegment segment) {
        if (this.files.remove(segmentDir)) {
            this.currSizeBytes -= segment.getSize();
        } else {
            log.warn("SegmentDir[%s] is not found under this location[%s]", new Object[]{segmentDir, this.path});
        }
    }

    @Nullable
    public synchronized File reserve(String segmentDir, DataSegment segment) {
        return this.reserve(segmentDir, segment.getId().toString(), segment.getSize());
    }

    public synchronized boolean isReserved(String segmentDir) {
        return this.files.contains(this.segmentDirectoryAsFile(segmentDir));
    }

    public File segmentDirectoryAsFile(String segmentDir) {
        return new File(this.path, segmentDir);
    }

    public synchronized void maybeReserve(String segmentFilePathToAdd, DataSegment segment) {
        File segmentFileToAdd = new File(this.path, segmentFilePathToAdd);
        if (this.files.contains(segmentFileToAdd)) {
            return;
        }
        this.files.add(segmentFileToAdd);
        this.currSizeBytes += segment.getSize();
        if (this.availableSizeBytes() < 0L) {
            log.makeAlert("storage[%s:%,d] has more segments than it is allowed. Currently loading Segment[%s:%,d]. Please increase druid.segmentCache.locations maxSize param", new Object[]{this.getPath(), this.availableSizeBytes(), segment.getId(), segment.getSize()}).emit();
        }
    }

    @Nullable
    public synchronized File reserve(String segmentFilePathToAdd, String segmentId, long segmentSize) {
        File segmentFileToAdd = new File(this.path, segmentFilePathToAdd);
        if (this.files.contains(segmentFileToAdd)) {
            return null;
        }
        if (this.canHandle(segmentId, segmentSize)) {
            this.files.add(segmentFileToAdd);
            this.currSizeBytes += segmentSize;
            return segmentFileToAdd;
        }
        return null;
    }

    public synchronized boolean release(String segmentFilePath, long segmentSize) {
        File segmentFile = new File(this.path, segmentFilePath);
        if (this.files.remove(segmentFile)) {
            this.currSizeBytes -= segmentSize;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @GuardedBy(value="this")
    boolean canHandle(String segmentId, long segmentSize) {
        long currFreeSpace;
        if (this.availableSizeBytes() < segmentSize) {
            log.warn("Segment[%s:%,d] too large for storage[%s:%,d]. Check your druid.segmentCache.locations maxSize param", new Object[]{segmentId, segmentSize, this.getPath(), this.availableSizeBytes()});
            return false;
        }
        if (this.freeSpaceToKeep > 0L && this.freeSpaceToKeep + segmentSize > (currFreeSpace = this.path.getFreeSpace())) {
            log.warn("Segment[%s:%,d] too large for storage[%s:%,d] to maintain suggested freeSpace[%d], current freeSpace is [%d].", new Object[]{segmentId, segmentSize, this.getPath(), this.availableSizeBytes(), this.freeSpaceToKeep, currFreeSpace});
            return false;
        }
        return true;
    }

    public synchronized long availableSizeBytes() {
        return this.maxSizeBytes - this.currSizeBytes;
    }

    public synchronized long currSizeBytes() {
        return this.currSizeBytes;
    }

    @VisibleForTesting
    synchronized boolean contains(String relativePath) {
        File segmentFileToAdd = new File(this.path, relativePath);
        return this.files.contains(segmentFileToAdd);
    }
}

