/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.common.config.Configs;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.utils.CollectionUtils;

public class CompactionStatus {
    private static final CompactionStatus COMPLETE = new CompactionStatus(State.COMPLETE, null);
    private static final List<Function<Evaluator, CompactionStatus>> CHECKS = Arrays.asList(rec$ -> ((Evaluator)rec$).segmentsHaveBeenCompactedAtLeastOnce(), rec$ -> ((Evaluator)rec$).allCandidatesHaveSameCompactionState(), rec$ -> ((Evaluator)rec$).partitionsSpecIsUpToDate(), rec$ -> ((Evaluator)rec$).indexSpecIsUpToDate(), rec$ -> ((Evaluator)rec$).segmentGranularityIsUpToDate(), rec$ -> ((Evaluator)rec$).queryGranularityIsUpToDate(), rec$ -> ((Evaluator)rec$).rollupIsUpToDate(), rec$ -> ((Evaluator)rec$).dimensionsSpecIsUpToDate(), rec$ -> ((Evaluator)rec$).metricsSpecIsUpToDate(), rec$ -> ((Evaluator)rec$).transformSpecFilterIsUpToDate(), rec$ -> ((Evaluator)rec$).projectionsAreUpToDate());
    private final State state;
    private final String reason;

    private CompactionStatus(State state, String reason) {
        this.state = state;
        this.reason = reason;
    }

    public boolean isComplete() {
        return this.state == State.COMPLETE;
    }

    public boolean isSkipped() {
        return this.state == State.SKIPPED;
    }

    public String getReason() {
        return this.reason;
    }

    public State getState() {
        return this.state;
    }

    public String toString() {
        return "CompactionStatus{state=" + String.valueOf((Object)this.state) + ", reason=" + this.reason + "}";
    }

    private static CompactionStatus incomplete(String reasonFormat, Object ... args) {
        return new CompactionStatus(State.PENDING, StringUtils.format((String)reasonFormat, (Object[])args));
    }

    private static <T> CompactionStatus completeIfEqual(String field, T configured, T current, Function<T, String> stringFunction) {
        if (configured == null || configured.equals(current)) {
            return COMPLETE;
        }
        return CompactionStatus.configChanged(field, configured, current, stringFunction);
    }

    private static <T> CompactionStatus configChanged(String field, T target, T current, Function<T, String> stringFunction) {
        return CompactionStatus.incomplete("'%s' mismatch: required[%s], current[%s]", field, target == null ? null : stringFunction.apply(target), current == null ? null : stringFunction.apply(current));
    }

    private static String asString(Granularity granularity) {
        if (granularity == null) {
            return null;
        }
        for (GranularityType type : GranularityType.values()) {
            if (!type.getDefaultGranularity().equals(granularity)) continue;
            return type.toString();
        }
        return granularity.toString();
    }

    private static String asString(PartitionsSpec partitionsSpec) {
        if (partitionsSpec instanceof DimensionRangePartitionsSpec) {
            DimensionRangePartitionsSpec rangeSpec = (DimensionRangePartitionsSpec)partitionsSpec;
            return StringUtils.format((String)"'range' on %s with %,d rows", (Object[])new Object[]{rangeSpec.getPartitionDimensions(), rangeSpec.getTargetRowsPerSegment()});
        }
        if (partitionsSpec instanceof HashedPartitionsSpec) {
            HashedPartitionsSpec hashedSpec = (HashedPartitionsSpec)partitionsSpec;
            return StringUtils.format((String)"'hashed' on %s with %,d rows", (Object[])new Object[]{hashedSpec.getPartitionDimensions(), hashedSpec.getTargetRowsPerSegment()});
        }
        if (partitionsSpec instanceof DynamicPartitionsSpec) {
            DynamicPartitionsSpec dynamicSpec = (DynamicPartitionsSpec)partitionsSpec;
            return StringUtils.format((String)"'dynamic' with %,d rows", (Object[])new Object[]{dynamicSpec.getMaxRowsPerSegment()});
        }
        return partitionsSpec.toString();
    }

    static CompactionStatus skipped(String reasonFormat, Object ... args) {
        return new CompactionStatus(State.SKIPPED, StringUtils.format((String)reasonFormat, (Object[])args));
    }

    static CompactionStatus running(String reasonForCompaction) {
        return new CompactionStatus(State.RUNNING, reasonForCompaction);
    }

    static CompactionStatus compute(CompactionCandidate candidateSegments, DataSourceCompactionConfig config, ObjectMapper objectMapper) {
        Evaluator evaluator = new Evaluator(candidateSegments, config, objectMapper);
        return CHECKS.stream().map(f -> (CompactionStatus)f.apply(evaluator)).filter(status -> !status.isComplete()).findFirst().orElse(COMPLETE);
    }

    static PartitionsSpec findPartitionsSpecFromConfig(ClientCompactionTaskQueryTuningConfig tuningConfig) {
        PartitionsSpec partitionsSpecFromTuningConfig = tuningConfig.getPartitionsSpec();
        if (partitionsSpecFromTuningConfig == null) {
            long maxTotalRows = Configs.valueOrDefault((Long)tuningConfig.getMaxTotalRows(), (long)Long.MAX_VALUE);
            return new DynamicPartitionsSpec(tuningConfig.getMaxRowsPerSegment(), Long.valueOf(maxTotalRows));
        }
        if (partitionsSpecFromTuningConfig instanceof DynamicPartitionsSpec) {
            return new DynamicPartitionsSpec(partitionsSpecFromTuningConfig.getMaxRowsPerSegment(), Long.valueOf(((DynamicPartitionsSpec)partitionsSpecFromTuningConfig).getMaxTotalRowsOr(Long.MAX_VALUE)));
        }
        if (partitionsSpecFromTuningConfig instanceof DimensionRangePartitionsSpec) {
            return CompactionStatus.getEffectiveRangePartitionsSpec((DimensionRangePartitionsSpec)partitionsSpecFromTuningConfig);
        }
        return partitionsSpecFromTuningConfig;
    }

    private static List<DimensionSchema> getNonPartitioningDimensions(@Nullable List<DimensionSchema> dimensionSchemas, @Nullable PartitionsSpec partitionsSpec) {
        if (dimensionSchemas == null || !(partitionsSpec instanceof DimensionRangePartitionsSpec)) {
            return dimensionSchemas;
        }
        List partitionsDimensions = ((DimensionRangePartitionsSpec)partitionsSpec).getPartitionDimensions();
        return dimensionSchemas.stream().filter(dim -> !partitionsDimensions.contains(dim.getName())).collect(Collectors.toList());
    }

    static DimensionRangePartitionsSpec getEffectiveRangePartitionsSpec(DimensionRangePartitionsSpec partitionsSpec) {
        return new DimensionRangePartitionsSpec(null, partitionsSpec.getMaxRowsPerSegment(), partitionsSpec.getPartitionDimensions(), partitionsSpec.isAssumeGrouped());
    }

    public static enum State {
        COMPLETE,
        PENDING,
        RUNNING,
        SKIPPED;

    }

    private static class Evaluator {
        private final ObjectMapper objectMapper;
        private final DataSourceCompactionConfig compactionConfig;
        private final CompactionCandidate candidateSegments;
        private final CompactionState lastCompactionState;
        private final ClientCompactionTaskQueryTuningConfig tuningConfig;
        private final ClientCompactionTaskGranularitySpec existingGranularitySpec;
        private final UserCompactionTaskGranularityConfig configuredGranularitySpec;

        private Evaluator(CompactionCandidate candidateSegments, DataSourceCompactionConfig compactionConfig, ObjectMapper objectMapper) {
            this.candidateSegments = candidateSegments;
            this.objectMapper = objectMapper;
            this.lastCompactionState = candidateSegments.getSegments().get(0).getLastCompactionState();
            this.compactionConfig = compactionConfig;
            this.tuningConfig = ClientCompactionTaskQueryTuningConfig.from(compactionConfig);
            this.configuredGranularitySpec = compactionConfig.getGranularitySpec();
            this.existingGranularitySpec = this.lastCompactionState == null ? null : this.convertIfNotNull(this.lastCompactionState.getGranularitySpec(), ClientCompactionTaskGranularitySpec.class);
        }

        private CompactionStatus segmentsHaveBeenCompactedAtLeastOnce() {
            if (this.lastCompactionState == null) {
                return CompactionStatus.incomplete("not compacted yet", new Object[0]);
            }
            return COMPLETE;
        }

        private CompactionStatus allCandidatesHaveSameCompactionState() {
            boolean allHaveSameCompactionState = this.candidateSegments.getSegments().stream().allMatch(segment -> this.lastCompactionState.equals((Object)segment.getLastCompactionState()));
            if (allHaveSameCompactionState) {
                return COMPLETE;
            }
            return CompactionStatus.incomplete("segments have different last compaction states", new Object[0]);
        }

        private CompactionStatus partitionsSpecIsUpToDate() {
            PartitionsSpec existingPartionsSpec = this.lastCompactionState.getPartitionsSpec();
            if (existingPartionsSpec instanceof DimensionRangePartitionsSpec) {
                existingPartionsSpec = CompactionStatus.getEffectiveRangePartitionsSpec((DimensionRangePartitionsSpec)existingPartionsSpec);
            }
            return CompactionStatus.completeIfEqual("partitionsSpec", CompactionStatus.findPartitionsSpecFromConfig(this.tuningConfig), existingPartionsSpec, x$0 -> CompactionStatus.asString(x$0));
        }

        private CompactionStatus indexSpecIsUpToDate() {
            return CompactionStatus.completeIfEqual("indexSpec", (IndexSpec)Configs.valueOrDefault((Object)this.tuningConfig.getIndexSpec(), (Object)IndexSpec.DEFAULT), (IndexSpec)this.objectMapper.convertValue((Object)this.lastCompactionState.getIndexSpec(), IndexSpec.class), String::valueOf);
        }

        private CompactionStatus projectionsAreUpToDate() {
            return CompactionStatus.completeIfEqual("projections", this.compactionConfig.getProjections(), this.lastCompactionState.getProjections(), String::valueOf);
        }

        private CompactionStatus segmentGranularityIsUpToDate() {
            Granularity existingSegmentGranularity;
            if (this.configuredGranularitySpec == null || this.configuredGranularitySpec.getSegmentGranularity() == null) {
                return COMPLETE;
            }
            Granularity configuredSegmentGranularity = this.configuredGranularitySpec.getSegmentGranularity();
            Granularity granularity = existingSegmentGranularity = this.existingGranularitySpec == null ? null : this.existingGranularitySpec.getSegmentGranularity();
            if (configuredSegmentGranularity.equals(existingSegmentGranularity)) {
                return COMPLETE;
            }
            if (existingSegmentGranularity == null) {
                boolean needsCompaction = this.candidateSegments.getSegments().stream().anyMatch(segment -> !configuredSegmentGranularity.isAligned(segment.getInterval()));
                if (needsCompaction) {
                    return CompactionStatus.incomplete("segmentGranularity: segments do not align with target[%s]", CompactionStatus.asString(configuredSegmentGranularity));
                }
            } else {
                return CompactionStatus.configChanged("segmentGranularity", configuredSegmentGranularity, existingSegmentGranularity, x$0 -> CompactionStatus.asString(x$0));
            }
            return COMPLETE;
        }

        private CompactionStatus rollupIsUpToDate() {
            if (this.configuredGranularitySpec == null) {
                return COMPLETE;
            }
            return CompactionStatus.completeIfEqual("rollup", this.configuredGranularitySpec.isRollup(), this.existingGranularitySpec == null ? null : this.existingGranularitySpec.isRollup(), String::valueOf);
        }

        private CompactionStatus queryGranularityIsUpToDate() {
            if (this.configuredGranularitySpec == null) {
                return COMPLETE;
            }
            return CompactionStatus.completeIfEqual("queryGranularity", this.configuredGranularitySpec.getQueryGranularity(), this.existingGranularitySpec == null ? null : this.existingGranularitySpec.getQueryGranularity(), x$0 -> CompactionStatus.asString(x$0));
        }

        private CompactionStatus dimensionsSpecIsUpToDate() {
            if (this.compactionConfig.getDimensionsSpec() == null) {
                return COMPLETE;
            }
            List<DimensionSchema> existingDimensions = CompactionStatus.getNonPartitioningDimensions(this.lastCompactionState.getDimensionsSpec() == null ? null : this.lastCompactionState.getDimensionsSpec().getDimensions(), this.lastCompactionState.getPartitionsSpec());
            List<DimensionSchema> configuredDimensions = CompactionStatus.getNonPartitioningDimensions(this.compactionConfig.getDimensionsSpec().getDimensions(), this.compactionConfig.getTuningConfig() == null ? null : this.compactionConfig.getTuningConfig().getPartitionsSpec());
            return CompactionStatus.completeIfEqual("dimensionsSpec", configuredDimensions, existingDimensions, String::valueOf);
        }

        private CompactionStatus metricsSpecIsUpToDate() {
            Object[] existingMetricsSpec;
            Object[] configuredMetricsSpec = this.compactionConfig.getMetricsSpec();
            if (ArrayUtils.isEmpty((Object[])configuredMetricsSpec)) {
                return COMPLETE;
            }
            List metricSpecList = this.lastCompactionState.getMetricsSpec();
            Object[] objectArray = existingMetricsSpec = CollectionUtils.isNullOrEmpty((Collection)metricSpecList) ? null : metricSpecList.toArray(new AggregatorFactory[0]);
            if (existingMetricsSpec == null || !Arrays.deepEquals(configuredMetricsSpec, existingMetricsSpec)) {
                return CompactionStatus.configChanged("metricsSpec", configuredMetricsSpec, existingMetricsSpec, Arrays::toString);
            }
            return COMPLETE;
        }

        private CompactionStatus transformSpecFilterIsUpToDate() {
            if (this.compactionConfig.getTransformSpec() == null) {
                return COMPLETE;
            }
            CompactionTransformSpec existingTransformSpec = this.convertIfNotNull(this.lastCompactionState.getTransformSpec(), CompactionTransformSpec.class);
            return CompactionStatus.completeIfEqual("transformSpec filter", this.compactionConfig.getTransformSpec().getFilter(), existingTransformSpec == null ? null : existingTransformSpec.getFilter(), String::valueOf);
        }

        @Nullable
        private <T> T convertIfNotNull(Object object, Class<T> clazz) {
            if (object == null) {
                return null;
            }
            return (T)this.objectMapper.convertValue(object, clazz);
        }
    }
}

