/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.compaction.CompactionTaskStatus;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class FixedIntervalOrderPolicy
implements CompactionCandidateSearchPolicy {
    private final List<Candidate> eligibleCandidates;

    @JsonCreator
    public FixedIntervalOrderPolicy(@JsonProperty(value="eligibleCandidates") List<Candidate> eligibleCandidates) {
        this.eligibleCandidates = eligibleCandidates;
    }

    @JsonProperty
    public List<Candidate> getEligibleCandidates() {
        return this.eligibleCandidates;
    }

    @Override
    public int compareCandidates(CompactionCandidate candidateA, CompactionCandidate candidateB) {
        return this.findIndex(candidateA) - this.findIndex(candidateB);
    }

    @Override
    public boolean isEligibleForCompaction(CompactionCandidate candidate, CompactionStatus currentCompactionStatus, CompactionTaskStatus latestTaskStatus) {
        return this.findIndex(candidate) < Integer.MAX_VALUE;
    }

    private int findIndex(CompactionCandidate candidate) {
        int index = 0;
        for (Candidate eligibleCandidate : this.eligibleCandidates) {
            boolean found;
            boolean bl = found = eligibleCandidate.datasource.equals(candidate.getDataSource()) && eligibleCandidate.interval.contains((ReadableInterval)candidate.getUmbrellaInterval());
            if (found) {
                return index;
            }
            ++index;
        }
        return Integer.MAX_VALUE;
    }

    public static class Candidate {
        private final String datasource;
        private final Interval interval;

        @JsonCreator
        public Candidate(@JsonProperty(value="datasource") String datasource, @JsonProperty(value="interval") Interval interval) {
            this.datasource = datasource;
            this.interval = interval;
        }

        @JsonProperty
        public String getDatasource() {
            return this.datasource;
        }

        @JsonProperty
        public Interval getInterval() {
            return this.interval;
        }
    }
}

