/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.balancer.ReservoirSegmentSampler;
import org.apache.druid.server.coordinator.balancer.SegmentToMoveCalculator;
import org.apache.druid.server.coordinator.loading.StrategicSegmentAssigner;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;

public class TierSegmentBalancer {
    private static final Logger log = new Logger(TierSegmentBalancer.class);
    private final String tier;
    private final DruidCoordinatorRuntimeParams params;
    private final StrategicSegmentAssigner segmentAssigner;
    private final CoordinatorRunStats runStats;
    private final List<ServerHolder> activeServers;
    private final List<ServerHolder> decommissioningServers;
    private final int maxSegmentsToMove;
    private final int movingSegmentCount;

    public TierSegmentBalancer(String tier, Set<ServerHolder> servers, int maxSegmentsToMove, DruidCoordinatorRuntimeParams params) {
        this.tier = tier;
        this.params = params;
        this.segmentAssigner = params.getSegmentAssigner();
        this.runStats = params.getCoordinatorStats();
        Map<Boolean, List<ServerHolder>> partitions = servers.stream().collect(Collectors.partitioningBy(ServerHolder::isDecommissioning));
        this.decommissioningServers = partitions.get(true);
        this.activeServers = partitions.get(false);
        this.movingSegmentCount = this.activeServers.stream().mapToInt(ServerHolder::getNumMovingSegments).sum();
        this.maxSegmentsToMove = maxSegmentsToMove;
    }

    public void run() {
        int numDecommSegmentsToMove = this.getNumDecommSegmentsToMove(this.maxSegmentsToMove);
        this.moveSegmentsFrom(this.decommissioningServers, numDecommSegmentsToMove, "decommissioning");
        int numActiveSegmentsToMove = this.getNumActiveSegmentsToMove(this.maxSegmentsToMove - numDecommSegmentsToMove);
        this.moveSegmentsFrom(this.activeServers, numActiveSegmentsToMove, "active");
    }

    private void moveSegmentsFrom(List<ServerHolder> sourceServers, int numSegmentsToMove, String sourceServerType) {
        if (numSegmentsToMove <= 0 || sourceServers.isEmpty() || this.activeServers.isEmpty()) {
            return;
        }
        Set<String> broadcastDatasources = this.params.getBroadcastDatasources();
        List<BalancerSegmentHolder> pickedSegments = ReservoirSegmentSampler.pickMovableSegmentsFrom(sourceServers, numSegmentsToMove, ServerHolder::getLoadingSegments, broadcastDatasources);
        int movedCount = this.moveSegmentsTo(this.activeServers, pickedSegments, numSegmentsToMove);
        if (this.movingSegmentCount <= 0) {
            int numLoadedSegmentsToMove = numSegmentsToMove - movedCount;
            pickedSegments = ReservoirSegmentSampler.pickMovableSegmentsFrom(sourceServers, numLoadedSegmentsToMove, server -> server.getServer().iterateAllSegments(), broadcastDatasources);
            movedCount += this.moveSegmentsTo(this.activeServers, pickedSegments, numLoadedSegmentsToMove);
        } else {
            log.debug("There are already [%,d] segments moving in tier[%s].", new Object[]{this.movingSegmentCount, this.tier});
        }
        log.debug("Moved [%,d of %,d] segments from [%d] [%s] servers in tier [%s].", new Object[]{movedCount, numSegmentsToMove, sourceServers.size(), sourceServerType, this.tier});
    }

    private int moveSegmentsTo(List<ServerHolder> destinationServers, List<BalancerSegmentHolder> movableSegments, int maxSegmentsToMove) {
        int processed = 0;
        int movedCount = 0;
        Iterator<BalancerSegmentHolder> segmentIterator = movableSegments.iterator();
        while (segmentIterator.hasNext() && processed < maxSegmentsToMove) {
            ++processed;
            BalancerSegmentHolder segmentHolder = segmentIterator.next();
            DataSegment segmentToMove = this.getLoadableSegment(segmentHolder.getSegment());
            if (segmentToMove == null || !this.segmentAssigner.moveSegment(segmentToMove, segmentHolder.getServer(), destinationServers)) continue;
            ++movedCount;
        }
        return movedCount;
    }

    @Nullable
    private DataSegment getLoadableSegment(DataSegment segmentToMove) {
        if (!this.params.isUsedSegment(segmentToMove)) {
            this.markUnmoved("Segment is unused", segmentToMove);
            return null;
        }
        ImmutableDruidDataSource datasource = this.params.getDataSourcesSnapshot().getDataSource(segmentToMove.getDataSource());
        if (datasource == null) {
            this.markUnmoved("Invalid datasource", segmentToMove);
            return null;
        }
        DataSegment loadableSegment = datasource.getSegment(segmentToMove.getId());
        if (loadableSegment == null) {
            this.markUnmoved("Invalid segment ID", segmentToMove);
            return null;
        }
        return loadableSegment;
    }

    private void markUnmoved(String reason, DataSegment segment) {
        RowKey key = RowKey.with(Dimension.TIER, this.tier).with(Dimension.DATASOURCE, segment.getDataSource()).and(Dimension.DESCRIPTION, reason);
        this.runStats.add(Stats.Segments.MOVE_SKIPPED, key, 1L);
    }

    private int getNumDecommSegmentsToMove(int maxSegmentsToMove) {
        if (this.decommissioningServers.isEmpty() || this.activeServers.isEmpty()) {
            return 0;
        }
        int decommSegmentsToMove = this.decommissioningServers.stream().mapToInt(server -> server.getProjectedSegments().getTotalSegmentCount()).sum();
        return Math.min(decommSegmentsToMove, maxSegmentsToMove);
    }

    private int getNumActiveSegmentsToMove(int maxActiveSegmentsToMove) {
        CoordinatorDynamicConfig dynamicConfig = this.params.getCoordinatorDynamicConfig();
        if (this.activeServers.size() < 2) {
            return 0;
        }
        if (dynamicConfig.isSmartSegmentLoading()) {
            return SegmentToMoveCalculator.computeNumSegmentsToMoveInTier(this.tier, this.activeServers, maxActiveSegmentsToMove);
        }
        return maxActiveSegmentsToMove;
    }
}

