/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.config;

import com.google.inject.Inject;
import org.apache.druid.error.DruidException;
import org.apache.druid.server.coordinator.balancer.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.config.CoordinatorKillConfigs;
import org.apache.druid.server.coordinator.config.CoordinatorPeriodConfig;
import org.apache.druid.server.coordinator.config.CoordinatorRunConfig;
import org.apache.druid.server.coordinator.config.HttpLoadQueuePeonConfig;
import org.apache.druid.server.coordinator.config.KillUnusedSegmentsConfig;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.joda.time.Duration;

public class DruidCoordinatorConfig {
    private final CoordinatorRunConfig runConfig;
    private final CoordinatorPeriodConfig periodConfig;
    private final CoordinatorKillConfigs killConfigs;
    private final BalancerStrategyFactory balancerStrategyFactory;
    private final HttpLoadQueuePeonConfig httpLoadQueuePeonConfig;

    @Inject
    public DruidCoordinatorConfig(CoordinatorRunConfig runConfig, CoordinatorPeriodConfig periodConfig, CoordinatorKillConfigs killConfigs, BalancerStrategyFactory balancerStrategyFactory, HttpLoadQueuePeonConfig httpLoadQueuePeonConfig) {
        this.killConfigs = killConfigs;
        this.runConfig = runConfig;
        this.periodConfig = periodConfig;
        this.balancerStrategyFactory = balancerStrategyFactory;
        this.httpLoadQueuePeonConfig = httpLoadQueuePeonConfig;
        this.validateKillConfigs();
    }

    public Duration getCoordinatorStartDelay() {
        return this.runConfig.getStartDelay();
    }

    public Duration getCoordinatorPeriod() {
        return this.runConfig.getPeriod();
    }

    public Duration getCoordinatorIndexingPeriod() {
        return this.periodConfig.getIndexingPeriod();
    }

    public Duration getCoordinatorMetadataStoreManagementPeriod() {
        return this.periodConfig.getMetadataStoreManagementPeriod();
    }

    public CoordinatorKillConfigs getKillConfigs() {
        return this.killConfigs;
    }

    public BalancerStrategyFactory getBalancerStrategyFactory() {
        return this.balancerStrategyFactory;
    }

    public HttpLoadQueuePeonConfig getHttpLoadQueuePeonConfig() {
        return this.httpLoadQueuePeonConfig;
    }

    private void validateKillConfigs() {
        this.validateKillConfig(this.killConfigs.auditLogs(), "audit");
        this.validateKillConfig(this.killConfigs.compactionConfigs(), "compaction");
        this.validateKillConfig(this.killConfigs.datasources(), "datasource");
        this.validateKillConfig(this.killConfigs.rules(), "rule");
        this.validateKillConfig(this.killConfigs.supervisors(), "supervisor");
        this.validateKillConfig(this.killConfigs.segmentSchemas(), "segmentSchema");
        KillUnusedSegmentsConfig killUnusedConfig = this.killConfigs.unusedSegments(this.getCoordinatorIndexingPeriod());
        if (killUnusedConfig.getCleanupPeriod().getMillis() < this.getCoordinatorIndexingPeriod().getMillis()) {
            throw DruidCoordinatorConfig.newInvalidInputExceptionForOperator("'druid.coordinator.kill.period'[%s] must be greater than or equal to 'druid.coordinator.period.indexingPeriod'[%s]", killUnusedConfig.getCleanupPeriod(), this.getCoordinatorIndexingPeriod());
        }
        if (killUnusedConfig.getMaxSegments() < 0) {
            throw DruidCoordinatorConfig.newInvalidInputExceptionForOperator("'druid.coordinator.kill.maxSegments'[%s] must be a positive integer.", killUnusedConfig.getMaxSegments());
        }
    }

    private void validateKillConfig(MetadataCleanupConfig config, String propertyPrefix) {
        if (!config.isCleanupEnabled()) {
            return;
        }
        Duration metadataManagementPeriod = this.getCoordinatorMetadataStoreManagementPeriod();
        Duration period = config.getCleanupPeriod();
        if (period == null || period.getMillis() < metadataManagementPeriod.getMillis()) {
            throw DruidCoordinatorConfig.newInvalidInputExceptionForOperator("'druid.coordinator.kill.%s.period'[%s] must be greater than 'druid.coordinator.period.metadataStoreManagementPeriod'[%s]", propertyPrefix, period, metadataManagementPeriod);
        }
        Duration retainDuration = config.getDurationToRetain();
        if (retainDuration == null || retainDuration.getMillis() < 0L) {
            throw DruidCoordinatorConfig.newInvalidInputExceptionForOperator("'druid.coordinator.kill.%s.durationToRetain'[%s] must be 0 milliseconds or higher", propertyPrefix, retainDuration);
        }
        if (retainDuration.getMillis() > System.currentTimeMillis()) {
            throw DruidCoordinatorConfig.newInvalidInputExceptionForOperator("'druid.coordinator.kill.%s.durationToRetain'[%s] cannot be greater than current time in milliseconds", propertyPrefix, retainDuration);
        }
    }

    private static DruidException newInvalidInputExceptionForOperator(String msgFormat, Object ... args) {
        return DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build(msgFormat, args);
    }
}

