/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.stats;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.server.coordinator.stats.Dimension;

public class RowKey {
    private static final RowKey EMPTY = new RowKey(Collections.emptyMap());
    private final Map<Dimension, String> values;
    private final int hashCode;

    private RowKey(Map<Dimension, String> values) {
        this.values = values;
        this.hashCode = Objects.hash(values);
    }

    public static Builder with(Dimension dimension, String value) {
        Builder builder = new Builder();
        builder.with(dimension, value);
        return builder;
    }

    public static RowKey of(Dimension dimension, String value) {
        return RowKey.with(dimension, value).build();
    }

    public static RowKey empty() {
        return EMPTY;
    }

    public Map<Dimension, String> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowKey that = (RowKey)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.values == null ? "{}" : this.values.toString();
    }

    public static class Builder {
        private final Map<Dimension, String> values = new EnumMap<Dimension, String>(Dimension.class);

        public Builder with(Dimension dimension, String value) {
            this.values.put(dimension, value);
            return this;
        }

        public RowKey and(Dimension dimension, String value) {
            this.values.put(dimension, value);
            return new RowKey(this.values);
        }

        public RowKey build() {
            return new RowKey(this.values);
        }
    }
}

