/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.druid.metadata.PasswordProvider;

public class TLSServerConfig {
    @JsonProperty
    private String keyStorePath;
    @JsonProperty
    private String keyStoreType;
    @JsonProperty
    private String certAlias;
    @JsonProperty(value="keyStorePassword")
    private PasswordProvider keyStorePasswordProvider;
    @JsonProperty(value="keyManagerPassword")
    private PasswordProvider keyManagerPasswordProvider;
    @JsonProperty
    private String keyManagerFactoryAlgorithm;
    @JsonProperty
    private List<String> includeCipherSuites;
    @JsonProperty
    private List<String> excludeCipherSuites;
    @JsonProperty
    private List<String> includeProtocols;
    @JsonProperty
    private List<String> excludeProtocols;
    @JsonProperty
    private boolean requireClientCertificate = false;
    @JsonProperty
    private boolean requestClientCertificate = false;
    @JsonProperty
    private String trustStoreType;
    @JsonProperty
    private String trustStorePath;
    @JsonProperty
    private String trustStoreAlgorithm;
    @JsonProperty(value="trustStorePassword")
    private PasswordProvider trustStorePasswordProvider;
    @JsonProperty
    private boolean validateHostnames = true;
    @JsonProperty
    private String crlPath;
    @JsonProperty
    private boolean reloadSslContext = false;
    @JsonProperty
    private int reloadSslContextSeconds = 60;

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public PasswordProvider getKeyStorePasswordProvider() {
        return this.keyStorePasswordProvider;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public PasswordProvider getKeyManagerPasswordProvider() {
        return this.keyManagerPasswordProvider;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public List<String> getIncludeCipherSuites() {
        return this.includeCipherSuites;
    }

    public List<String> getExcludeCipherSuites() {
        return this.excludeCipherSuites;
    }

    public List<String> getIncludeProtocols() {
        return this.includeProtocols;
    }

    public List<String> getExcludeProtocols() {
        return this.excludeProtocols;
    }

    public boolean isRequireClientCertificate() {
        return this.requireClientCertificate;
    }

    public boolean isRequestClientCertificate() {
        return this.requestClientCertificate;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public PasswordProvider getTrustStorePasswordProvider() {
        return this.trustStorePasswordProvider;
    }

    public boolean isValidateHostnames() {
        return this.validateHostnames;
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public int getReloadSslContextSeconds() {
        return this.reloadSslContextSeconds;
    }

    public boolean isReloadSslContext() {
        return this.reloadSslContext;
    }

    public String toString() {
        return "TLSServerConfig{keyStorePath='" + this.keyStorePath + "', keyStoreType='" + this.keyStoreType + "', certAlias='" + this.certAlias + "', keyManagerFactoryAlgorithm='" + this.keyManagerFactoryAlgorithm + "', includeCipherSuites=" + String.valueOf(this.includeCipherSuites) + ", excludeCipherSuites=" + String.valueOf(this.excludeCipherSuites) + ", includeProtocols=" + String.valueOf(this.includeProtocols) + ", excludeProtocols=" + String.valueOf(this.excludeProtocols) + ", requireClientCertificate=" + this.requireClientCertificate + ", requestClientCertificate=" + this.requestClientCertificate + ", trustStoreType='" + this.trustStoreType + "', trustStorePath='" + this.trustStorePath + "', trustStoreAlgorithm='" + this.trustStoreAlgorithm + "', validateHostnames='" + this.validateHostnames + "', crlPath='" + this.crlPath + "', reloadSslContext='" + this.reloadSslContext + "', reloadSslContextSeconds='" + this.reloadSslContextSeconds + "'}";
    }
}

