/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.server.metrics.SubqueryCountStatsProvider;

public class SubqueryCountStatsMonitor
extends AbstractMonitor {
    private static final String KEY = "subqueryCountStats";
    private static final String ROW_LIMIT_COUNT = "subquery/rowLimit/count";
    private static final String BYTE_LIMIT_COUNT = "subquery/byteLimit/count";
    private static final String FALLBACK_COUNT = "subquery/fallback/count";
    private static final String INSUFFICIENT_TYPE_COUNT = "subquery/fallback/insufficientType/count";
    private static final String UNKNOWN_REASON_COUNT = "subquery/fallback/unknownReason/count";
    private static final String ROW_LIMIT_EXCEEDED_COUNT = "query/rowLimit/exceeded/count";
    private static final String BYTE_LIMIT_EXCEEDED_COUNT = "query/byteLimit/exceeded/count";
    private final KeyedDiff keyedDiff = new KeyedDiff();
    private final SubqueryCountStatsProvider statsProvider;

    @Inject
    public SubqueryCountStatsMonitor(SubqueryCountStatsProvider statsProvider) {
        this.statsProvider = statsProvider;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        long subqueriesWithRowBasedLimit = this.statsProvider.subqueriesWithRowLimit();
        long subqueriesWithByteBasedLimit = this.statsProvider.subqueriesWithByteLimit();
        long subqueriesFallingBackToRowBasedLimit = this.statsProvider.subqueriesFallingBackToRowLimit();
        long subqueriesFallingBackDueToUnsufficientTypeInfo = this.statsProvider.subqueriesFallingBackDueToUnsufficientTypeInfo();
        long subqueriesFallingBackDueToUnknownReason = this.statsProvider.subqueriesFallingBackDueUnknownReason();
        long queriesExceedingRowLimit = this.statsProvider.queriesExceedingRowLimit();
        long queriesExceedingByteLimit = this.statsProvider.queriesExceedingByteLimit();
        Map diff = this.keyedDiff.to(KEY, (Map)ImmutableMap.of((Object)ROW_LIMIT_COUNT, (Object)subqueriesWithRowBasedLimit, (Object)BYTE_LIMIT_COUNT, (Object)subqueriesWithByteBasedLimit, (Object)FALLBACK_COUNT, (Object)subqueriesFallingBackToRowBasedLimit, (Object)INSUFFICIENT_TYPE_COUNT, (Object)subqueriesFallingBackDueToUnsufficientTypeInfo, (Object)UNKNOWN_REASON_COUNT, (Object)subqueriesFallingBackDueToUnknownReason, (Object)ROW_LIMIT_EXCEEDED_COUNT, (Object)queriesExceedingRowLimit, (Object)BYTE_LIMIT_EXCEEDED_COUNT, (Object)queriesExceedingByteLimit));
        if (diff != null) {
            for (Map.Entry diffEntry : diff.entrySet()) {
                emitter.emit((ServiceEventBuilder)builder.setMetric((String)diffEntry.getKey(), (Number)diffEntry.getValue()));
            }
        }
        return true;
    }
}

