/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.common.aws.AWSCredentialsConfig;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.kinesis.KinesisRecordEntity;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskIOConfig;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskRunner;
import org.apache.druid.indexing.kinesis.KinesisIndexTaskTuningConfig;
import org.apache.druid.indexing.kinesis.KinesisRecordSupplier;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.utils.RuntimeInfo;

public class KinesisIndexTask
extends SeekableStreamIndexTask<String, String, KinesisRecordEntity> {
    private static final String TYPE = "index_kinesis";
    private static final long GET_RECORDS_MAX_BYTES_PER_CALL = 10000000L;
    private static final Logger log = new Logger(KinesisIndexTask.class);
    private final boolean useListShards;
    private final AWSCredentialsConfig awsCredentialsConfig;
    private RuntimeInfo runtimeInfo;

    @JsonCreator
    public KinesisIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") KinesisIndexTaskTuningConfig tuningConfig, @JsonProperty(value="ioConfig") KinesisIndexTaskIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="useListShards") boolean useListShards, @JacksonInject @Named(value="kinesis") AWSCredentialsConfig awsCredentialsConfig) {
        super(KinesisIndexTask.getOrMakeId((String)id, (String)dataSchema.getDataSource(), (String)TYPE), taskResource, dataSchema, (SeekableStreamIndexTaskTuningConfig)tuningConfig, (SeekableStreamIndexTaskIOConfig)ioConfig, context, KinesisIndexTask.getFormattedGroupId((String)dataSchema.getDataSource(), (String)TYPE));
        this.useListShards = useListShards;
        this.awsCredentialsConfig = awsCredentialsConfig;
    }

    public TaskStatus runTask(TaskToolbox toolbox) {
        this.runtimeInfo = toolbox.getAdjustedRuntimeInfo();
        if (this.getTuningConfig().getRecordBufferSizeConfigured() != null) {
            log.warn("The 'recordBufferSize' config property of the kinesis tuning config has been deprecated. Please use 'recordBufferSizeBytes'.", new Object[0]);
        }
        if (this.getTuningConfig().getMaxRecordsPerPollConfigured() != null) {
            log.warn("The 'maxRecordsPerPoll' config property of the kinesis tuning config has been deprecated. Please use 'maxBytesPerPoll'.", new Object[0]);
        }
        return super.runTask(toolbox);
    }

    protected SeekableStreamIndexTaskRunner<String, String, KinesisRecordEntity> createTaskRunner() {
        return new KinesisIndexTaskRunner(this, (InputRowParser<ByteBuffer>)this.dataSchema.getParser(), this.authorizerMapper, this.lockGranularityToUse);
    }

    protected KinesisRecordSupplier newTaskRecordSupplier(TaskToolbox toolbox) throws RuntimeException {
        KinesisIndexTaskIOConfig ioConfig = (KinesisIndexTaskIOConfig)this.ioConfig;
        KinesisIndexTaskTuningConfig tuningConfig = (KinesisIndexTaskTuningConfig)this.tuningConfig;
        int recordBufferSizeBytes = tuningConfig.getRecordBufferSizeBytesOrDefault(this.runtimeInfo.getMaxHeapSizeBytes());
        int fetchThreads = KinesisIndexTask.computeFetchThreads(this.runtimeInfo, tuningConfig.getFetchThreads());
        int maxBytesPerPoll = tuningConfig.getMaxBytesPerPollOrDefault();
        log.info("Starting record supplier with fetchThreads [%d], fetchDelayMillis [%d], recordBufferSizeBytes [%d], maxBytesPerPoll [%d]", new Object[]{fetchThreads, ioConfig.getFetchDelayMillis(), recordBufferSizeBytes, maxBytesPerPoll});
        return new KinesisRecordSupplier(KinesisRecordSupplier.getAmazonKinesisClient(ioConfig.getEndpoint(), this.awsCredentialsConfig, ioConfig.getAwsAssumedRoleArn(), ioConfig.getAwsExternalId()), ioConfig.getFetchDelayMillis(), fetchThreads, recordBufferSizeBytes, tuningConfig.getRecordBufferOfferTimeout(), tuningConfig.getRecordBufferFullWait(), maxBytesPerPoll, false, this.useListShards);
    }

    @JsonProperty
    public KinesisIndexTaskTuningConfig getTuningConfig() {
        return (KinesisIndexTaskTuningConfig)super.getTuningConfig();
    }

    @JsonProperty(value="ioConfig")
    public KinesisIndexTaskIOConfig getIOConfig() {
        return (KinesisIndexTaskIOConfig)super.getIOConfig();
    }

    public String getType() {
        return TYPE;
    }

    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return Collections.singleton(new ResourceAction(new Resource("kinesis", "EXTERNAL"), Action.READ));
    }

    public boolean supportsQueries() {
        return true;
    }

    @VisibleForTesting
    AWSCredentialsConfig getAwsCredentialsConfig() {
        return this.awsCredentialsConfig;
    }

    @VisibleForTesting
    static int computeFetchThreads(RuntimeInfo runtimeInfo, Integer configuredFetchThreads) {
        long memoryToUse;
        int maxFetchThreads;
        int fetchThreads = configuredFetchThreads != null ? configuredFetchThreads : runtimeInfo.getAvailableProcessors() * 2;
        if (fetchThreads > (maxFetchThreads = Math.max(1, (int)((memoryToUse = Math.min(100000000L, (long)((double)runtimeInfo.getMaxHeapSizeBytes() * 0.05))) / 10000000L)))) {
            if (configuredFetchThreads != null) {
                log.warn("fetchThreads [%d] being lowered to [%d]", new Object[]{configuredFetchThreads, maxFetchThreads});
            }
            fetchThreads = maxFetchThreads;
        }
        Preconditions.checkArgument((fetchThreads > 0 ? 1 : 0) != 0, (Object)"Must have at least one background fetch thread for the record supplier");
        return fetchThreads;
    }
}

