/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.CreateIntegrationResult;
import com.amazonaws.services.rds.model.IntegrationError;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.services.rds.model.transform.IntegrationErrorStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class CreateIntegrationResultStaxUnmarshaller
implements Unmarshaller<CreateIntegrationResult, StaxUnmarshallerContext> {
    private static CreateIntegrationResultStaxUnmarshaller instance;

    public CreateIntegrationResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        CreateIntegrationResult createIntegrationResult = new CreateIntegrationResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return createIntegrationResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceArn", targetDepth)) {
                    createIntegrationResult.setSourceArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetArn", targetDepth)) {
                    createIntegrationResult.setTargetArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IntegrationName", targetDepth)) {
                    createIntegrationResult.setIntegrationName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IntegrationArn", targetDepth)) {
                    createIntegrationResult.setIntegrationArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KMSKeyId", targetDepth)) {
                    createIntegrationResult.setKMSKeyId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AdditionalEncryptionContext/entry", targetDepth)) {
                    Map.Entry<String, String> entry = AdditionalEncryptionContextMapEntryUnmarshaller.getInstance().unmarshall(context);
                    createIntegrationResult.addAdditionalEncryptionContextEntry(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    createIntegrationResult.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    createIntegrationResult.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("Tags/Tag", targetDepth)) {
                    createIntegrationResult.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    createIntegrationResult.setCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Errors", targetDepth)) {
                    createIntegrationResult.withErrors(new ArrayList<IntegrationError>());
                    continue;
                }
                if (!context.testExpression("Errors/IntegrationError", targetDepth)) continue;
                createIntegrationResult.withErrors(IntegrationErrorStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return createIntegrationResult;
    }

    public static CreateIntegrationResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CreateIntegrationResultStaxUnmarshaller();
        }
        return instance;
    }

    private static class AdditionalEncryptionContextMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static AdditionalEncryptionContextMapEntryUnmarshaller instance;

        private AdditionalEncryptionContextMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static AdditionalEncryptionContextMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new AdditionalEncryptionContextMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

