/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.uri;

import java.util.Objects;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.MiscUtils;
import org.jetbrains.annotations.Nullable;

final class UriParser {
    @Nullable
    public String scheme;
    @Nullable
    public String host;
    public int port = -1;
    @Nullable
    public String query;
    @Nullable
    public String fragment;
    @Nullable
    private String authority;
    public String path = "";
    @Nullable
    public String userInfo;
    private final String originalUrl;
    private int start;
    private int end;
    private int currentIndex;

    private UriParser(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    private void trimLeft() {
        while (this.start < this.end && this.originalUrl.charAt(this.start) <= ' ') {
            ++this.start;
        }
        if (this.originalUrl.regionMatches(true, this.start, "url:", 0, 4)) {
            this.start += 4;
        }
    }

    private void trimRight() {
        this.end = this.originalUrl.length();
        while (this.end > 0 && this.originalUrl.charAt(this.end - 1) <= ' ') {
            --this.end;
        }
    }

    private boolean isFragmentOnly() {
        return this.start < this.originalUrl.length() && this.originalUrl.charAt(this.start) == '#';
    }

    private static boolean isValidProtocolChar(char c) {
        return Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-';
    }

    private static boolean isValidProtocolChars(String protocol) {
        for (int i = 1; i < protocol.length(); ++i) {
            if (UriParser.isValidProtocolChar(protocol.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidProtocol(String protocol) {
        return protocol.length() > 0 && Character.isLetter(protocol.charAt(0)) && UriParser.isValidProtocolChars(protocol);
    }

    private void computeInitialScheme() {
        for (int i = this.currentIndex; i < this.end; ++i) {
            char c = this.originalUrl.charAt(i);
            if (c == ':') {
                String s = this.originalUrl.substring(this.currentIndex, i);
                if (!UriParser.isValidProtocol(s)) break;
                this.scheme = s.toLowerCase();
                this.currentIndex = i + 1;
                break;
            }
            if (c == '/') break;
        }
    }

    private boolean overrideWithContext(@Nullable Uri context) {
        boolean isRelative = false;
        if (context != null && (this.scheme == null || this.scheme.equalsIgnoreCase(context.getScheme()))) {
            String contextPath = context.getPath();
            if (MiscUtils.isNonEmpty(contextPath) && contextPath.charAt(0) == '/') {
                this.scheme = null;
            }
            if (this.scheme == null) {
                this.scheme = context.getScheme();
                this.userInfo = context.getUserInfo();
                this.host = context.getHost();
                this.port = context.getPort();
                this.path = contextPath;
                isRelative = true;
            }
        }
        return isRelative;
    }

    private int findWithinCurrentRange(char c) {
        int pos = this.originalUrl.indexOf(c, this.currentIndex);
        return pos > this.end ? -1 : pos;
    }

    private void trimFragment() {
        int charpPosition = this.findWithinCurrentRange('#');
        if (charpPosition >= 0) {
            this.end = charpPosition;
            if (charpPosition + 1 < this.originalUrl.length()) {
                this.fragment = this.originalUrl.substring(charpPosition + 1);
            }
        }
    }

    private void inheritContextQuery(@Nullable Uri context, boolean isRelative) {
        if (isRelative && this.currentIndex == this.end) {
            this.query = context.getQuery();
            this.fragment = context.getFragment();
        }
    }

    private boolean computeQuery() {
        int askPosition;
        if (this.currentIndex < this.end && (askPosition = this.findWithinCurrentRange('?')) != -1) {
            this.query = this.originalUrl.substring(askPosition + 1, this.end);
            if (this.end > askPosition) {
                this.end = askPosition;
            }
            return askPosition == this.currentIndex;
        }
        return false;
    }

    private boolean currentPositionStartsWith4Slashes() {
        return this.originalUrl.regionMatches(this.currentIndex, "////", 0, 4);
    }

    private boolean currentPositionStartsWith2Slashes() {
        return this.originalUrl.regionMatches(this.currentIndex, "//", 0, 2);
    }

    private String computeAuthority() {
        int authorityEndPosition = this.findWithinCurrentRange('/');
        if (authorityEndPosition == -1 && (authorityEndPosition = this.findWithinCurrentRange('?')) == -1) {
            authorityEndPosition = this.end;
        }
        this.host = this.authority = this.originalUrl.substring(this.currentIndex, authorityEndPosition);
        this.currentIndex = authorityEndPosition;
        return this.authority;
    }

    private void computeUserInfo(String nonNullAuthority) {
        int atPosition = nonNullAuthority.indexOf(64);
        if (atPosition != -1) {
            this.userInfo = nonNullAuthority.substring(0, atPosition);
            this.host = nonNullAuthority.substring(atPosition + 1);
        } else {
            this.userInfo = null;
        }
    }

    private static boolean isMaybeIPV6(String nonNullHost) {
        return nonNullHost.length() > 0 && nonNullHost.charAt(0) == '[';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeIPV6(String nonNullHost) {
        int positionAfterClosingSquareBrace = nonNullHost.indexOf(93) + 1;
        if (positionAfterClosingSquareBrace <= 1) throw new IllegalArgumentException("Invalid authority field: " + this.authority);
        this.port = -1;
        if (nonNullHost.length() > positionAfterClosingSquareBrace) {
            if (nonNullHost.charAt(positionAfterClosingSquareBrace) != ':') throw new IllegalArgumentException("Invalid authority field: " + this.authority);
            int portPosition = positionAfterClosingSquareBrace + 1;
            if (nonNullHost.length() > portPosition) {
                this.port = Integer.parseInt(nonNullHost.substring(portPosition));
            }
        }
        this.host = nonNullHost.substring(0, positionAfterClosingSquareBrace);
    }

    private void computeRegularHostPort(String nonNullHost) {
        int colonPosition = nonNullHost.indexOf(58);
        this.port = -1;
        if (colonPosition >= 0) {
            int portPosition = colonPosition + 1;
            if (nonNullHost.length() > portPosition) {
                this.port = Integer.parseInt(nonNullHost.substring(portPosition));
            }
            this.host = nonNullHost.substring(0, colonPosition);
        }
    }

    private void removeEmbeddedDot() {
        this.path = this.path.replace("/./", "/");
    }

    private void removeEmbedded2Dots() {
        int i = 0;
        while ((i = this.path.indexOf("/../", i)) >= 0) {
            if (i > 0) {
                this.end = this.path.lastIndexOf(47, i - 1);
                if (this.end >= 0 && this.path.indexOf("/../", this.end) != 0) {
                    this.path = this.path.substring(0, this.end) + this.path.substring(i + 3);
                    i = 0;
                    continue;
                }
                if (this.end != 0) continue;
                break;
            }
            i += 3;
        }
    }

    private void removeTailing2Dots() {
        while (this.path.endsWith("/..")) {
            this.end = this.path.lastIndexOf(47, this.path.length() - 4);
            if (this.end < 0) break;
            this.path = this.path.substring(0, this.end + 1);
        }
    }

    private void removeStartingDot() {
        if (this.path.startsWith("./") && this.path.length() > 2) {
            this.path = this.path.substring(2);
        }
    }

    private void removeTrailingDot() {
        if (this.path.endsWith("/.")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    private void handleRelativePath() {
        int lastSlashPosition = this.path.lastIndexOf(47);
        String pathEnd = this.originalUrl.substring(this.currentIndex, this.end);
        this.path = lastSlashPosition == -1 ? (this.authority != null ? "/" + pathEnd : pathEnd) : this.path.substring(0, lastSlashPosition + 1) + pathEnd;
    }

    private void handlePathDots() {
        if (this.path.indexOf(46) != -1) {
            this.removeEmbeddedDot();
            this.removeEmbedded2Dots();
            this.removeTailing2Dots();
            this.removeStartingDot();
            this.removeTrailingDot();
        }
    }

    private void parseAuthority() {
        if (!this.currentPositionStartsWith4Slashes() && this.currentPositionStartsWith2Slashes()) {
            this.currentIndex += 2;
            String nonNullAuthority = this.computeAuthority();
            this.computeUserInfo(nonNullAuthority);
            if (this.host != null) {
                String nonNullHost = this.host;
                if (UriParser.isMaybeIPV6(nonNullHost)) {
                    this.computeIPV6(nonNullHost);
                } else {
                    this.computeRegularHostPort(nonNullHost);
                }
            }
            if (this.port < -1) {
                throw new IllegalArgumentException("Invalid port number :" + this.port);
            }
            if (MiscUtils.isNonEmpty(this.authority)) {
                this.path = "";
            }
        }
    }

    private void computeRegularPath() {
        if (this.originalUrl.charAt(this.currentIndex) == '/') {
            this.path = this.originalUrl.substring(this.currentIndex, this.end);
        } else if (MiscUtils.isNonEmpty(this.path)) {
            this.handleRelativePath();
        } else {
            String pathEnd = this.originalUrl.substring(this.currentIndex, this.end);
            this.path = MiscUtils.isNonEmpty(pathEnd) && pathEnd.charAt(0) != '/' ? "/" + pathEnd : pathEnd;
        }
        this.handlePathDots();
    }

    private void computeQueryOnlyPath() {
        int lastSlashPosition = this.path.lastIndexOf(47);
        this.path = lastSlashPosition < 0 ? "/" : this.path.substring(0, lastSlashPosition) + "/";
    }

    private void computePath(boolean queryOnly) {
        if (this.currentIndex < this.end) {
            this.computeRegularPath();
        } else if (queryOnly) {
            this.computeQueryOnlyPath();
        }
    }

    private void parse(@Nullable Uri context) {
        this.end = this.originalUrl.length();
        this.trimLeft();
        this.trimRight();
        this.currentIndex = this.start;
        if (!this.isFragmentOnly()) {
            this.computeInitialScheme();
        }
        boolean isRelative = this.overrideWithContext(context);
        this.trimFragment();
        this.inheritContextQuery(context, isRelative);
        boolean queryOnly = this.computeQuery();
        this.parseAuthority();
        this.computePath(queryOnly);
    }

    public static UriParser parse(@Nullable Uri context, String originalUrl) {
        Objects.requireNonNull(originalUrl, "originalUrl");
        UriParser parser = new UriParser(originalUrl);
        parser.parse(context);
        return parser;
    }
}

