/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AsciiString;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Param;
import org.asynchttpclient.Request;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.StringBuilderPool;
import org.asynchttpclient.util.StringUtils;
import org.asynchttpclient.util.Utf8UrlEncoder;
import org.jetbrains.annotations.Nullable;

public final class HttpUtils {
    public static final AsciiString ACCEPT_ALL_HEADER_VALUE = new AsciiString((CharSequence)"*/*");
    public static final AsciiString GZIP_DEFLATE = new AsciiString((CharSequence)(HttpHeaderValues.GZIP + "," + HttpHeaderValues.DEFLATE));
    private static final String CONTENT_TYPE_CHARSET_ATTRIBUTE = "charset=";
    private static final String CONTENT_TYPE_BOUNDARY_ATTRIBUTE = "boundary=";
    private static final String BROTLY_ACCEPT_ENCODING_SUFFIX = ", br";
    private static final String ZSTD_ACCEPT_ENCODING_SUFFIX = ", zstd";
    private static final byte[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);

    private HttpUtils() {
    }

    public static String hostHeader(Uri uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        return port == -1 || port == uri.getSchemeDefaultPort() ? host : host + ":" + port;
    }

    public static String originHeader(Uri uri) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        sb.append(uri.isSecured() ? "https://" : "http://").append(uri.getHost());
        if (uri.getExplicitPort() != uri.getSchemeDefaultPort()) {
            sb.append(':').append(uri.getPort());
        }
        return sb.toString();
    }

    @Nullable
    public static Charset extractContentTypeCharsetAttribute(String contentType) {
        String charsetName = HttpUtils.extractContentTypeAttribute(contentType, CONTENT_TYPE_CHARSET_ATTRIBUTE);
        return charsetName != null ? Charset.forName(charsetName) : null;
    }

    @Nullable
    public static String extractContentTypeBoundaryAttribute(String contentType) {
        return HttpUtils.extractContentTypeAttribute(contentType, CONTENT_TYPE_BOUNDARY_ATTRIBUTE);
    }

    @Nullable
    private static String extractContentTypeAttribute(@Nullable String contentType, String attribute) {
        if (contentType == null) {
            return null;
        }
        for (int i = 0; i < contentType.length(); ++i) {
            char c;
            int end;
            char c2;
            int start;
            if (!contentType.regionMatches(true, i, attribute, 0, attribute.length())) continue;
            for (start = i + attribute.length(); start < contentType.length() && ((c2 = contentType.charAt(start)) == ' ' || c2 == '\'' || c2 == '\"'); ++start) {
            }
            if (start == contentType.length()) break;
            for (end = start + 1; end < contentType.length() && (c = contentType.charAt(end)) != ' ' && c != '\'' && c != '\"' && c != ';'; ++end) {
            }
            return contentType.substring(start, end);
        }
        return null;
    }

    public static byte[] computeMultipartBoundary() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes = new byte[random.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    public static String patchContentTypeWithBoundaryAttribute(String base, byte[] boundary) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append(base);
        if (!base.isEmpty() && base.charAt(base.length() - 1) != ';') {
            sb.append(';');
        }
        return sb.append(' ').append(CONTENT_TYPE_BOUNDARY_ATTRIBUTE).append(new String(boundary, StandardCharsets.US_ASCII)).toString();
    }

    public static boolean followRedirect(AsyncHttpClientConfig config, Request request) {
        return request.getFollowRedirect() != null ? request.getFollowRedirect().booleanValue() : config.isFollowRedirect();
    }

    public static ByteBuffer urlEncodeFormParams(List<Param> params, Charset charset) {
        return StringUtils.charSequence2ByteBuffer(HttpUtils.urlEncodeFormParams0(params, charset), StandardCharsets.US_ASCII);
    }

    private static StringBuilder urlEncodeFormParams0(List<Param> params, Charset charset) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        for (Param param : params) {
            HttpUtils.encodeAndAppendFormParam(sb, param.getName(), param.getValue(), charset);
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    private static void encodeAndAppendFormParam(StringBuilder sb, String name, @Nullable String value, Charset charset) {
        HttpUtils.encodeAndAppendFormField(sb, name, charset);
        if (value != null) {
            sb.append('=');
            HttpUtils.encodeAndAppendFormField(sb, value, charset);
        }
        sb.append('&');
    }

    private static void encodeAndAppendFormField(StringBuilder sb, String field, Charset charset) {
        if (charset.equals(StandardCharsets.UTF_8)) {
            Utf8UrlEncoder.encodeAndAppendFormElement(sb, field);
        } else {
            sb.append(URLEncoder.encode(field, charset));
        }
    }

    public static CharSequence filterOutBrotliFromAcceptEncoding(String acceptEncoding) {
        if (acceptEncoding.endsWith(BROTLY_ACCEPT_ENCODING_SUFFIX)) {
            return acceptEncoding.subSequence(0, acceptEncoding.length() - BROTLY_ACCEPT_ENCODING_SUFFIX.length());
        }
        return acceptEncoding;
    }

    public static CharSequence filterOutZstdFromAcceptEncoding(String acceptEncoding) {
        if (acceptEncoding.endsWith(ZSTD_ACCEPT_ENCODING_SUFFIX)) {
            return acceptEncoding.subSequence(0, acceptEncoding.length() - ZSTD_ACCEPT_ENCODING_SUFFIX.length());
        }
        return acceptEncoding;
    }
}

