/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class MiscUtils {
    private MiscUtils() {
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNonEmpty(@Nullable String string) {
        return !MiscUtils.isEmpty(string);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNonEmpty(@Nullable Object[] array) {
        return array != null && array.length != 0;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNonEmpty(byte @Nullable [] array) {
        return array != null && array.length != 0;
    }

    @Contract(value="null -> false")
    public static boolean isNonEmpty(@Nullable Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    @Contract(value="null -> false")
    public static boolean isNonEmpty(@Nullable Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static <T> T withDefault(@Nullable T value, T def) {
        return value == null ? def : value;
    }

    public static void closeSilently(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Throwable getCause(Throwable t) {
        Throwable cause = t.getCause();
        return cause != null ? MiscUtils.getCause(cause) : t;
    }
}

