/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaIterator;
import net.spy.memcached.KetamaNodeKeyFormatter;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedNodeROImpl;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;

public final class KetamaNodeLocator
extends SpyObject
implements NodeLocator {
    private volatile TreeMap<Long, MemcachedNode> ketamaNodes;
    private volatile Collection<MemcachedNode> allNodes;
    private final HashAlgorithm hashAlg;
    private final Map<InetSocketAddress, Integer> weights;
    private final boolean isWeightedKetama;
    private final KetamaNodeLocatorConfiguration config;

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg) {
        this(nodes, alg, KetamaNodeKeyFormatter.Format.SPYMEMCACHED, new HashMap<InetSocketAddress, Integer>());
    }

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg, KetamaNodeKeyFormatter.Format nodeKeyFormat, Map<InetSocketAddress, Integer> weights) {
        this(nodes, alg, weights, new DefaultKetamaNodeLocatorConfiguration(new KetamaNodeKeyFormatter(nodeKeyFormat)));
    }

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg, KetamaNodeLocatorConfiguration conf) {
        this(nodes, alg, new HashMap<InetSocketAddress, Integer>(), conf);
    }

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg, Map<InetSocketAddress, Integer> nodeWeights, KetamaNodeLocatorConfiguration configuration) {
        this.allNodes = nodes;
        this.hashAlg = alg;
        this.config = configuration;
        this.weights = nodeWeights;
        this.isWeightedKetama = !this.weights.isEmpty();
        this.setKetamaNodes(nodes);
    }

    private KetamaNodeLocator(TreeMap<Long, MemcachedNode> smn, Collection<MemcachedNode> an, HashAlgorithm alg, Map<InetSocketAddress, Integer> nodeWeights, KetamaNodeLocatorConfiguration conf) {
        this.ketamaNodes = smn;
        this.allNodes = an;
        this.hashAlg = alg;
        this.config = conf;
        this.weights = nodeWeights;
        this.isWeightedKetama = !this.weights.isEmpty();
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        MemcachedNode rv = this.getNodeForKey(this.hashAlg.hash(k));
        assert (rv != null) : "Found no node for key " + k;
        return rv;
    }

    long getMaxKey() {
        return this.getKetamaNodes().lastKey();
    }

    MemcachedNode getNodeForKey(long hash) {
        if (!this.ketamaNodes.containsKey(hash)) {
            SortedMap<Long, MemcachedNode> tailMap = this.getKetamaNodes().tailMap(hash);
            hash = tailMap.isEmpty() ? this.getKetamaNodes().firstKey().longValue() : tailMap.firstKey().longValue();
        }
        MemcachedNode rv = this.getKetamaNodes().get(hash);
        return rv;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new KetamaIterator(k, 7, this.getKetamaNodes(), this.hashAlg);
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, MemcachedNode> smn = new TreeMap<Long, MemcachedNode>((SortedMap<Long, MemcachedNode>)this.getKetamaNodes());
        ArrayList<MemcachedNode> an = new ArrayList<MemcachedNode>(this.allNodes.size());
        for (Map.Entry<Long, MemcachedNode> me : smn.entrySet()) {
            smn.put(me.getKey(), new MemcachedNodeROImpl(me.getValue()));
        }
        for (MemcachedNode n : this.allNodes) {
            an.add(new MemcachedNodeROImpl(n));
        }
        return new KetamaNodeLocator(smn, an, this.hashAlg, this.weights, this.config);
    }

    @Override
    public void updateLocator(List<MemcachedNode> nodes) {
        this.allNodes = nodes;
        this.setKetamaNodes(nodes);
        this.allNodes = nodes;
    }

    protected TreeMap<Long, MemcachedNode> getKetamaNodes() {
        return this.ketamaNodes;
    }

    protected void setKetamaNodes(List<MemcachedNode> nodes) {
        TreeMap<Long, MemcachedNode> newNodeMap = new TreeMap<Long, MemcachedNode>();
        int numReps = this.config.getNodeRepetitions();
        int nodeCount = nodes.size();
        int totalWeight = 0;
        if (this.isWeightedKetama) {
            for (MemcachedNode node : nodes) {
                totalWeight += this.weights.get(node.getSocketAddress()).intValue();
            }
        }
        for (MemcachedNode node : nodes) {
            int i;
            if (this.isWeightedKetama) {
                int thisWeight = this.weights.get(node.getSocketAddress());
                float percent = (float)thisWeight / (float)totalWeight;
                int pointerPerServer = (int)(Math.floor((float)((double)(percent * (float)this.config.getNodeRepetitions() / 4.0f * (float)nodeCount) + 1.0E-10)) * 4.0);
                for (int i2 = 0; i2 < pointerPerServer / 4; ++i2) {
                    for (long position : this.ketamaNodePositionsAtIteration(node, i2)) {
                        newNodeMap.put(position, node);
                        this.getLogger().debug("Adding node %s with weight %s in position %d", node, thisWeight, position);
                    }
                }
                continue;
            }
            if (this.hashAlg == DefaultHashAlgorithm.KETAMA_HASH) {
                for (i = 0; i < numReps / 4; ++i) {
                    for (long position : this.ketamaNodePositionsAtIteration(node, i)) {
                        newNodeMap.put(position, node);
                        this.getLogger().debug("Adding node %s in position %d", node, position);
                    }
                }
                continue;
            }
            for (i = 0; i < numReps; ++i) {
                newNodeMap.put(this.hashAlg.hash(this.config.getKeyForNode(node, i)), node);
            }
        }
        assert (newNodeMap.size() == numReps * nodes.size());
        this.ketamaNodes = newNodeMap;
    }

    private List<Long> ketamaNodePositionsAtIteration(MemcachedNode node, int iteration) {
        ArrayList<Long> positions = new ArrayList<Long>();
        byte[] digest = DefaultHashAlgorithm.computeHashDigest(this.config.getKeyForNode(node, iteration));
        for (int h = 0; h < 4; ++h) {
            Long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
            positions.add(k);
        }
        return positions;
    }
}

